/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods;

import com.thedrofdoctoring.vampiricageing.AgeingReference;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.HuntingMethod;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import com.thedrofdoctoring.vampiricageing.data.EntityTypeTagProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class HunterHuntingMethod
extends HuntingMethod {
    private static final String ID = "HUNTING";
    private static int[] points;

    @Override
    public void onAgedKill(LivingEntity target, Player sourceKiller) {
        int pointWorth = 0;
        if (target.getType().is(EntityTypeTagProvider.pettyHunt)) {
            pointWorth = (Integer)HunterAgeingConfig.pettyHuntWorth.get();
        } else if (target.getType().is(EntityTypeTagProvider.commonHunt)) {
            pointWorth = (Integer)HunterAgeingConfig.commonHuntWorth.get();
        } else if (target.getType().is(EntityTypeTagProvider.greaterHunt)) {
            pointWorth = (Integer)HunterAgeingConfig.greaterHuntWorth.get();
        }
        AgeingManager.getAge(sourceKiller).increaseRankPoints(pointWorth);
    }

    @Override
    public int[] getRankProgressions() {
        if (points == null) {
            points = Arrays.stream(((List)HunterAgeingConfig.huntedForNextAge.get()).toArray()).mapToInt(o -> (Integer)o).toArray();
        }
        return points;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isEnabled() {
        return ((String)HunterAgeingConfig.ageingMethod.get()).equals(this.getId());
    }

    @Override
    public IAgeType getValidType() {
        return AgeingReference.HUNTER;
    }

    @Override
    public String getRemainingLang() {
        return "text.vampiricageing.progress_hunted";
    }
}

