/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods;

import com.thedrofdoctoring.vampiricageing.AgeingReference;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.HuntingMethod;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.data.EntityTypeTagProvider;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class VampHuntingMethod
extends HuntingMethod {
    private static final String ID = "V_HUNTING";
    private static int[] points;

    @Override
    public void onAgedKill(LivingEntity target, Player sourceKiller) {
        int pointWorth = 0;
        if (target.getType().is(EntityTypeTagProvider.pettyHuntVampire)) {
            pointWorth = (Integer)CommonConfig.pettyHuntWorth.get();
        } else if (target.getType().is(EntityTypeTagProvider.commonHuntVampire)) {
            pointWorth = (Integer)CommonConfig.commonHuntWorth.get();
        } else if (target.getType().is(EntityTypeTagProvider.greaterHuntVampire)) {
            pointWorth = (Integer)CommonConfig.greaterHuntWorth.get();
        }
        AgeingManager.getAge(sourceKiller).increaseRankPoints(pointWorth);
    }

    @Override
    public boolean isEnabled() {
        return ((String)CommonConfig.ageingMethod.get()).equals(this.getId());
    }

    @Override
    public int[] getRankProgressions() {
        if (points == null) {
            points = Arrays.stream(((List)CommonConfig.huntedForNextAge.get()).toArray()).mapToInt(o -> (Integer)o).toArray();
        }
        return points;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public IAgeType getValidType() {
        return AgeingReference.VAMP;
    }

    @Override
    public String getRemainingLang() {
        return "text.vampiricageing.progress_hunted_vampire";
    }
}

