/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.types;

import com.thedrofdoctoring.vampiricageing.VampiricAgeing;
import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import com.thedrofdoctoring.vampiricageing.skills.VampiricAgeingSkills;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class HunterAgeingType
implements IAgeType {
    private static final String id = "HUNTER";

    @Override
    public IPlayableFaction<?> faction() {
        return VReference.HUNTER_FACTION;
    }

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getAgeAttributes(int age, Player player, boolean cleanup) {
        HashMap<Holder<Attribute>, AttributeModifier> attributeMap = new HashMap<Holder<Attribute>, AttributeModifier>();
        attributeMap.put(Attributes.MAX_HEALTH, new AttributeModifier(VampiricAgeing.rl("hunter_ageing_max_health"), ((Double)((List)HunterAgeingConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put(Attributes.MOVEMENT_SPEED, new AttributeModifier(VampiricAgeing.rl("hunter_ageing_speed"), ((Double)((List)HunterAgeingConfig.movementSpeedBonus.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        int cumulativeTaintedBloodAge = CapabilityHelper.getCumulativeTaintedAge(player);
        attributeMap.put(Attributes.ATTACK_DAMAGE, new AttributeModifier(VampiricAgeing.rl("hunter_ageing_attack_damage"), ((Double)((List)HunterAgeingConfig.taintedDamageBonuses.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put(Attributes.MAX_HEALTH, new AttributeModifier(VampiricAgeing.rl("hunter_tainted_ageing_max_health"), ((Double)((List)HunterAgeingConfig.taintedBloodMaxHealthIncreases.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put(Attributes.MOVEMENT_SPEED, new AttributeModifier(VampiricAgeing.rl("hunter_tainted_ageing_speed"), ((Double)((List)HunterAgeingConfig.taintedBloodMovementSpeedIncreases.get()).get(cumulativeTaintedBloodAge)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        return attributeMap;
    }

    @Override
    public void handleSkills(int age, ServerPlayer player) {
        ISkillHandler skillHandler = HunterPlayer.get((Player)player).getSkillHandler();
        int taintedAge = CapabilityHelper.getCumulativeTaintedAge((Player)player);
        if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
            skillHandler.enableSkill((ISkill)VampiricAgeingSkills.TAINTED_BLOOD_SKILL.get());
        } else {
            skillHandler.disableSkill((ISkill)VampiricAgeingSkills.TAINTED_BLOOD_SKILL.get());
        }
        if (taintedAge >= (Integer)HunterAgeingConfig.hunterTeleportActionAge.get()) {
            skillHandler.enableSkill((ISkill)VampiricAgeingSkills.HUNTER_TELEPORT_SKILL.get());
        } else {
            skillHandler.disableSkill((ISkill)VampiricAgeingSkills.HUNTER_TELEPORT_SKILL.get());
        }
        if (taintedAge >= (Integer)HunterAgeingConfig.limitedBatModeAge.get()) {
            skillHandler.enableSkill((ISkill)VampiricAgeingSkills.LIMITED_BAT_MODE_SKILL.get());
        } else {
            skillHandler.disableSkill((ISkill)VampiricAgeingSkills.LIMITED_BAT_MODE_SKILL.get());
        }
    }

    @Override
    public int minFactionRank() {
        return (Integer)HunterAgeingConfig.levelToBeginAgeMechanic.get();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)HunterAgeingConfig.hunterAgeing.get();
    }

    @Override
    public String getId() {
        return id;
    }

    public Optional<HunterState> getStateType() {
        return Optional.of(new HunterState());
    }

    public static class HunterState
    extends TypeState {
        int taintedAgeBonus = 0;
        int taintedTicks = 0;
        int ticksInSun;
        boolean transformed = false;

        public int getTemporaryTaintedAgeBonus() {
            return this.taintedAgeBonus;
        }

        public void setTemporaryTaintedAgeBonus(int bonus) {
            this.taintedAgeBonus = bonus;
        }

        public int getTemporaryTainedTicks() {
            return this.taintedTicks;
        }

        public void setTicksInSun(int ticks) {
            this.ticksInSun = ticks;
        }

        public int getTicksInSun() {
            return this.ticksInSun;
        }

        public void setTemporaryTaintedTicks(int ticks) {
            this.taintedTicks = ticks;
        }

        public boolean isTransformed() {
            return this.transformed;
        }

        public void setTransformed(boolean transformed) {
            this.transformed = transformed;
        }

        @Override
        @NotNull
        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            nbt.putInt("ageing_tainted_age", this.taintedAgeBonus);
            nbt.putInt("ageing_tainted_ticks", this.taintedTicks);
            nbt.putInt("ageing_sun_ticks", this.ticksInSun);
            nbt.putBoolean("ageing_transformed", this.transformed);
            return nbt;
        }

        @Override
        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            if (nbt.getString("ageing_type").isEmpty()) {
                this.ticksInSun = 0;
                this.transformed = false;
                this.taintedTicks = 0;
                this.taintedAgeBonus = 0;
            } else {
                this.taintedAgeBonus = nbt.getInt("ageing_tainted_age");
                this.taintedTicks = nbt.getInt("ageing_tainted_ticks");
                this.ticksInSun = nbt.getInt("ageing_sun_ticks");
                this.transformed = nbt.getBoolean("ageing_transformed");
            }
        }

        @Override
        public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            if (nbt.getString("ageing_type").isEmpty()) {
                this.ticksInSun = 0;
                this.transformed = false;
                this.taintedTicks = 0;
                this.taintedAgeBonus = 0;
            } else {
                this.taintedAgeBonus = nbt.getInt("ageing_tainted_age");
                this.taintedTicks = nbt.getInt("ageing_tainted_ticks");
                this.ticksInSun = nbt.getInt("ageing_sun_ticks");
                this.transformed = nbt.getBoolean("ageing_transformed");
            }
        }

        @Override
        @NotNull
        public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            nbt.putInt("ageing_tainted_age", this.taintedAgeBonus);
            nbt.putInt("ageing_tainted_ticks", this.taintedTicks);
            nbt.putInt("ageing_sun_ticks", this.ticksInSun);
            nbt.putBoolean("ageing_transformed", this.transformed);
            return nbt;
        }
    }
}

