/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.ageing.types;

import com.thedrofdoctoring.vampiricageing.VampiricAgeing;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.config.WerewolvesAgeingConfig;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.core.ModAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;

public class WerewolfAgeingType
implements IAgeType {
    private static final String id = "WEREWOLF";

    @Override
    public IPlayableFaction<?> faction() {
        return WReference.WEREWOLF_FACTION;
    }

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getAgeAttributes(int age, Player player, boolean cleanup) {
        HashMap<Holder<Attribute>, AttributeModifier> attributeMap = new HashMap<Holder<Attribute>, AttributeModifier>();
        attributeMap.put(Attributes.ATTACK_DAMAGE, new AttributeModifier(VampiricAgeing.rl("werewolf_ageing_attack_damage_increase"), ((Double)((List)WerewolvesAgeingConfig.ageDamageIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put(Attributes.MAX_HEALTH, new AttributeModifier(VampiricAgeing.rl("werewolf_ageing_max_health"), ((Double)((List)WerewolvesAgeingConfig.maxHealthIncrease.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        attributeMap.put((Holder<Attribute>)ModAttributes.BITE_DAMAGE, new AttributeModifier(VampiricAgeing.rl("werewolf_ageing_bite_damage"), ((Double)((List)WerewolvesAgeingConfig.biteDamageMultiplier.get()).get(age)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return attributeMap;
    }

    @Override
    public void handleSkills(int age, ServerPlayer player) {
    }

    @Override
    public int minFactionRank() {
        return (Integer)CommonConfig.levelToBeginAgeMechanic.get();
    }

    @Override
    public boolean isEnabled() {
        return ModList.get().isLoaded("werewolves") && (Boolean)WerewolvesAgeingConfig.werewolfAgeing.get() != false;
    }

    @Override
    public String getId() {
        return id;
    }

    public Optional<TypeState> getStateType() {
        return Optional.empty();
    }
}

