/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.handlers;

import com.thedrofdoctoring.vampiricageing.actions.LimitedHunterBatModeAction;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.HunterAgeingType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.capabilities.other.IHunterSpecialAttributes;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import com.thedrofdoctoring.vampiricageing.mixin.FoodStatsAccessor;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="vampiricageing")
public class HunterAgeingHandler {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        ServerPlayer player;
        AgeingManager age;
        TypeState typeState;
        LivingEntity livingEntity;
        if (Helper.isHunter((Entity)event.getEntity()) && (livingEntity = event.getEntity()) instanceof ServerPlayer && (typeState = (age = AgeingManager.getAge((Player)(player = (ServerPlayer)livingEntity))).getTypeState()) instanceof HunterAgeingType.HunterState) {
            HunterAgeingType.HunterState state = (HunterAgeingType.HunterState)typeState;
            if (((Boolean)HunterAgeingConfig.permanentTransformationDeathReset.get()).booleanValue()) {
                state.setTransformed(false);
            }
            state.setTemporaryTaintedAgeBonus(0);
            state.setTemporaryTaintedTicks(0);
            state.setTicksInSun(0);
            age.sync(false);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(EntityTickEvent.Post event) {
        HunterAgeingType.HunterState state;
        AgeingManager manager;
        TypeState stats;
        if (event.getEntity().level().getGameTime() % 20L != 0L) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!Helper.isHunter((Player)player) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        int age = AgeingManager.getAge(player).getAge();
        if (age >= (Integer)HunterAgeingConfig.fasterRegenerationAge.get() && !player.getCommandSenderWorld().isClientSide()) {
            Difficulty difficulty = player.level().getDifficulty();
            boolean flag = player.level().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION);
            stats = player.getFoodData();
            if (flag && stats.getSaturationLevel() > 0.0f && player.isHurt() && stats.getFoodLevel() >= 20) {
                if (((FoodStatsAccessor)((Object)stats)).getFoodTimer() >= 9) {
                    float f = Math.min(stats.getSaturationLevel(), 6.0f);
                    player.heal(f / 6.0f);
                    stats.addExhaustion(f);
                }
            } else if (flag && stats.getFoodLevel() >= 18 && player.isHurt()) {
                if (((FoodStatsAccessor)((Object)stats)).getFoodTimer() >= 79) {
                    player.heal(1.0f);
                    stats.addExhaustion(6.0f);
                }
            } else if (stats.getFoodLevel() <= 0 && ((FoodStatsAccessor)((Object)stats)).getFoodTimer() >= 79 && (player.getHealth() > 10.0f || difficulty == Difficulty.HARD || player.getHealth() > 1.0f && difficulty == Difficulty.NORMAL)) {
                DamageHandler.hurtVanilla((Entity)player, DamageSources::starve, (float)1.0f);
            }
        }
        if (((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue() && (stats = (manager = AgeingManager.getAge(player)).getTypeState()) instanceof HunterAgeingType.HunterState && ((state = (HunterAgeingType.HunterState)stats).getTemporaryTaintedAgeBonus() > 0 || state.isTransformed())) {
            if (!state.isTransformed()) {
                state.setTemporaryTaintedTicks(state.getTemporaryTainedTicks() - 20);
                if (state.getTemporaryTainedTicks() <= 0) {
                    state.setTemporaryTaintedAgeBonus(0);
                }
            }
            int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
            if (((Boolean)HunterAgeingConfig.sunAffectTainted.get()).booleanValue() && cumulativeAge >= (Integer)HunterAgeingConfig.taintedSunAffectAge.get()) {
                int ticksInSun = state.getTicksInSun();
                if (Helper.gettingSundamge((LivingEntity)player, (LevelAccessor)player.getCommandSenderWorld(), (ProfilerFiller)player.getCommandSenderWorld().getProfiler()) && ticksInSun <= (Integer)HunterAgeingConfig.maxTicksInSun.get()) {
                    state.setTicksInSun(ticksInSun + 20 * (Integer)((List)HunterAgeingConfig.taintedAgeSunBadnessMultiplier.get()).get(cumulativeAge));
                } else if (state.getTicksInSun() >= 100) {
                    int reductionAmount = state.getTicksInSun() < 1000 ? 60 : 250;
                    state.setTicksInSun(Math.max(0, ticksInSun - reductionAmount));
                }
                HunterAgeingHandler.applySunEffects(player, state.getTicksInSun());
            }
            if (cumulativeAge >= (Integer)HunterAgeingConfig.underwaterBreathingTaintedAge.get()) {
                player.setAirSupply(300);
            }
            manager.sync(false);
        }
    }

    public static void applySunEffects(Player player, int ticksInSun) {
        if (player.getAbilities().instabuild || player.hasEffect((Holder)ModEffects.SUNSCREEN)) {
            return;
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunWeaknessTicks.get()) {
            player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 0));
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunSlownessTicks.get() && ticksInSun < (Integer)HunterAgeingConfig.sunSlownessThreeTicks.get()) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
        } else if (ticksInSun >= (Integer)HunterAgeingConfig.sunSlownessThreeTicks.get()) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 2));
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get()) {
            float baseDamage = ((Double)HunterAgeingConfig.baseSunDamageAmount.get()).floatValue();
            DamageHandler.hurtModded((Entity)player, ModDamageSources::sunDamage, (float)baseDamage);
            if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get() * 2) {
                DamageHandler.hurtModded((Entity)player, ModDamageSources::sunDamage, (float)baseDamage);
            }
            if (ticksInSun >= (Integer)HunterAgeingConfig.sunDamageTicks.get() * 3) {
                DamageHandler.hurtModded((Entity)player, ModDamageSources::sunDamage, (float)baseDamage);
            }
        }
        if (ticksInSun >= (Integer)HunterAgeingConfig.sunBlindnessTicks.get()) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 0));
        }
    }

    @SubscribeEvent
    public static void onInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (event.getHand() == InteractionHand.MAIN_HAND && Helper.isHunter((Player)player) && !player.getCommandSenderWorld().isClientSide) {
            AgeingManager manager = AgeingManager.getAge(player);
            if (player.getCommandSenderWorld().getBlockState(event.getPos()).getBlock() instanceof MedChairBlock && manager.canAge()) {
                int age = manager.getAge();
                int points = manager.getRankProgress();
                int pointsForNextAge = manager.getMethod().getRankProgressions()[age] - points;
                player.sendSystemMessage((Component)Component.translatable((String)"text.vampiricageing.progress_hunted", (Object[])new Object[]{pointsForNextAge}).withStyle(ChatFormatting.DARK_RED));
            }
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (event.getItemStack().is((Item)ModItems.INJECTION_GARLIC.get()) && CapabilityHelper.getCumulativeTaintedAge(player) > 0) {
            AgeingManager age = AgeingManager.getAge(player);
            TypeState typeState = age.getTypeState();
            if (typeState instanceof HunterAgeingType.HunterState) {
                HunterAgeingType.HunterState state = (HunterAgeingType.HunterState)typeState;
                state.setTemporaryTaintedAgeBonus(0);
                state.setTemporaryTaintedTicks(0);
                state.setTransformed(false);
            }
            age.sync(false);
            event.getItemStack().shrink(1);
        }
    }

    @SubscribeEvent
    public static void onDamageByHunter(LivingIncomingDamageEvent event) {
        if (event.getSource().getEntity() == null || event.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        Entity sourceEntity = event.getSource().getEntity();
        if (!(Helper.isHunter((Entity)sourceEntity) && ((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue() && sourceEntity instanceof Player)) {
            return;
        }
        ItemStack item = ((Player)sourceEntity).getMainHandItem();
        ItemAttributeModifiers modifiers = item.getAttributeModifiers();
        double baseDamage = 0.0;
        for (ItemAttributeModifiers.Entry modifier : modifiers.modifiers()) {
            if (modifier.attribute().is(Attributes.ATTACK_DAMAGE)) {
                // empty if block
            }
            baseDamage = modifier.modifier().amount();
        }
        if (!(baseDamage >= 2.0) || Helper.isVampire((Entity)event.getEntity()) || CapabilityHelper.isWerewolfCheckMod((Entity)event.getEntity())) {
            // empty if block
        }
        Player hunterSource = (Player)sourceEntity;
        int age = AgeingManager.getAge(hunterSource).getAge();
        event.setAmount(event.getAmount() + ((Double)((List)HunterAgeingConfig.ageEnemyFactionDamageIncrease.get()).get(age)).floatValue());
    }

    @SubscribeEvent
    public static void onDamageHunter(LivingIncomingDamageEvent event) {
        if (!Helper.isHunter((Entity)event.getEntity()) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (CapabilityHelper.getCumulativeTaintedAge(player) > 0 && !player.getCommandSenderWorld().isClientSide) {
            int cumulativeAge = CapabilityHelper.getCumulativeTaintedAge(player);
            if (event.getSource().is(DamageTypes.ON_FIRE) || event.getSource().is(DamageTypes.IN_FIRE)) {
                event.setAmount(event.getAmount() * ((Double)((List)HunterAgeingConfig.taintedFireDamageMultiplier.get()).get(cumulativeAge)).floatValue());
            }
        }
    }

    @SubscribeEvent
    public static void onXpGain(PlayerXpEvent.XpChange event) {
        Player player = event.getEntity();
        if (!Helper.isHunter((Player)player) || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        int age = AgeingManager.getAge(player).getAge();
        event.setAmount(Math.round((float)event.getAmount() / ((Double)((List)HunterAgeingConfig.xpGainReduction.get()).get(age)).floatValue()));
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)HunterAgeingConfig.hunterIncreasedMiningSpeed.get()).booleanValue() || !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
            return;
        }
        if (!Helper.isHunter((Player)event.getEntity())) {
            return;
        }
        if (HunterAgeingHandler.isBat(event.getEntity())) {
            event.setCanceled(true);
        }
        int age = AgeingManager.getAge(event.getEntity()).getAge();
        event.setNewSpeed(event.getOriginalSpeed() * ((Double)((List)HunterAgeingConfig.hunterMiningSpeedBonus.get()).get(age)).floatValue());
    }

    @SubscribeEvent
    public static void eyeHeight(EntityEvent.Size event) {
        Player player;
        boolean batMode;
        if (event.getEntity() instanceof Player && ((Player)event.getEntity()).getInventory() != null && event.getEntity().isAlive() && event.getEntity().position().lengthSqr() != 0.0 && event.getEntity().getVehicle() == null && (batMode = HunterAgeingHandler.isBat(player = (Player)event.getEntity()))) {
            event.setNewSize(LimitedHunterBatModeAction.BAT_SIZE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.isAlive() && HunterAgeingHandler.isBat(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTryMount(EntityMountEvent event) {
        if (event.getEntity() instanceof Player && HunterAgeingHandler.isBat((Player)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (HunterAgeingHandler.isBat(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(LivingEntityUseItemEvent.Start event) {
        Player player;
        if (event.getEntity() instanceof Player && HunterAgeingHandler.isBat(player = (Player)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if ((event.getItemStack().getItem() instanceof ThrowablePotionItem || event.getItemStack().getItem() instanceof CrossbowItem) && HunterAgeingHandler.isBat(event.getEntity())) {
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getEntity().isAlive()) {
            return;
        }
        if (event.getPlacedBlock().isAir()) {
            return;
        }
        try {
            if (HunterAgeingHandler.isBat((Player)event.getEntity())) {
                MinecraftServer server;
                BlockEntity t;
                event.setCanceled(true);
                if (event.getPlacedBlock().hasBlockEntity() && (t = event.getLevel().getBlockEntity(event.getPos())) instanceof Container) {
                    ((Container)t).clearContent();
                }
                if (event.getEntity() instanceof ServerPlayer && (server = event.getEntity().level().getServer()) != null) {
                    server.getPlayerList().sendAllPlayerInfo((ServerPlayer)event.getEntity());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBat(Player player) {
        return ((IHunterSpecialAttributes)HunterPlayer.get((Player)player).getSpecialAttributes()).ageing$getBatMode();
    }
}

