/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities.handlers;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.DevourMethod;
import com.thedrofdoctoring.vampiricageing.config.WerewolvesAgeingConfig;
import com.thedrofdoctoring.vampiricageing.data.EntityTypeTagProvider;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.core.ModDamageTypes;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class WerewolfAgeingHandler {
    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getSource().is(ModDamageTypes.BITE)) {
                AgeingManager age = AgeingManager.getAge(player);
                if (!(age.getMethod() instanceof DevourMethod)) {
                    return;
                }
                int pointWorth = event.getEntity().getType().is(EntityTypeTagProvider.pettyDevour) ? (Integer)WerewolvesAgeingConfig.pettyDevourWorth.get() : (event.getEntity().getType().is(EntityTypeTagProvider.commonDevour) ? (Integer)WerewolvesAgeingConfig.commonDevourWorth.get() : (event.getEntity().getType().is(EntityTypeTagProvider.greaterDevour) ? (Integer)WerewolvesAgeingConfig.greaterDevourWorth.get() : (event.getEntity().getType().is(EntityTypeTagProvider.exquisiteDevour) ? (Integer)WerewolvesAgeingConfig.exquisiteDevourWorth.get() : 0)));
                age.increaseRankPoints(pointWorth);
                age.sync(false);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        AgeingManager manager = AgeingManager.getAge(player);
        if (Helper.isWerewolf((Player)player) && !player.getCommandSenderWorld().isClientSide && player.getCommandSenderWorld().getBlockState(event.getPos()).getBlock() instanceof StoneAltarFireBowlBlock && manager.canAge() && event.getHand() == InteractionHand.MAIN_HAND) {
            int points = manager.getRankProgress();
            points = (Integer)((List)WerewolvesAgeingConfig.devouredForNextAge.get()).get(manager.getAge()) - points;
            player.displayClientMessage((Component)Component.translatable((String)manager.getMethod().getRemainingLang(), (Object[])new Object[]{points}).withStyle(ChatFormatting.DARK_RED), true);
        }
    }

    @SubscribeEvent
    public void onHurt(LivingIncomingDamageEvent event) {
        Player player;
        Entity entity;
        if (event.getSource().is(ModDamageTypes.BITE) && (entity = event.getSource().getEntity()) instanceof Player && Helper.isWerewolf((Player)(player = (Player)entity)) && !player.getCommandSenderWorld().isClientSide) {
            AgeingManager manager = AgeingManager.getAge(player);
            int age = manager.getAge();
            player.heal(((Double)((List)WerewolvesAgeingConfig.healonBiteAmount.get()).get(age)).floatValue());
            if (((Boolean)WerewolvesAgeingConfig.bitingGivesFood.get()).booleanValue() && age >= (Integer)WerewolvesAgeingConfig.rankForBiteFood.get()) {
                FoodData foodData = player.getFoodData();
                foodData.eat(((Integer)WerewolvesAgeingConfig.biteNutrition.get()).intValue(), ((Double)WerewolvesAgeingConfig.biteSaturation.get()).floatValue());
            }
        }
    }

    @SubscribeEvent
    public void onFoodEatenFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (Helper.isWerewolf((Player)((Player)event.getEntity())) && Helper.isRawMeat((LivingEntity)player, (ItemStack)event.getItem())) {
                AgeingManager manager = AgeingManager.getAge(player);
                int age = manager.getAge();
                int multiplier = (Integer)((List)WerewolvesAgeingConfig.nourishmentMultipliers.get()).get(age) - 1;
                for (int i = 1; i <= multiplier; ++i) {
                    player.eat(player.getCommandSenderWorld(), event.getItem());
                }
            }
        }
    }
}

