/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.client.init;

import com.thedrofdoctoring.vampiricageing.capabilities.other.IHunterSpecialAttributes;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import org.jetbrains.annotations.NotNull;

public class ClientRenderHandler {
    private final Minecraft mc;

    public ClientRenderHandler(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderPlayerPreHigh(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        boolean batMode = ((IHunterSpecialAttributes)HunterPlayer.get((Player)player).getSpecialAttributes()).ageing$getBatMode();
        if (batMode) {
            event.setCanceled(true);
            Bat bat = (Bat)player.getData((Supplier)ModAttachments.VAMPIRE_BAT);
            float partialTicks = event.getPartialTick();
            bat.yBodyRotO = player.yBodyRotO;
            bat.yBodyRot = player.yBodyRot;
            bat.tickCount = player.tickCount;
            bat.setXRot(player.getXRot());
            bat.setYRot(player.getYRot());
            bat.yHeadRot = player.yHeadRot;
            bat.yRotO = player.yRotO;
            bat.xRotO = player.xRotO;
            bat.yHeadRotO = player.yHeadRotO;
            bat.setInvisible(player.isInvisible());
            double d0 = Mth.lerp((double)partialTicks, (double)bat.xOld, (double)bat.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)bat.yOld, (double)bat.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)bat.zOld, (double)bat.getZ());
            float f = Mth.lerp((float)partialTicks, (float)bat.yRotO, (float)bat.getYRot());
            this.mc.getEntityRenderDispatcher().render((Entity)bat, d0, d1, d2, f, partialTicks, event.getPoseStack(), (MultiBufferSource)this.mc.renderBuffers().bufferSource(), this.mc.getEntityRenderDispatcher().getPackedLightCoords((Entity)bat, partialTicks));
        }
    }

    @SubscribeEvent
    public void onRenderHand(@NotNull RenderHandEvent event) {
        if (this.mc.player == null) {
            return;
        }
        HunterPlayer player = HunterPlayer.get((Player)this.mc.player);
        IHunterSpecialAttributes specialAttributes = (IHunterSpecialAttributes)player.getSpecialAttributes();
        if (this.mc.player.isAlive() && player.getSpecialAttributes() != null && specialAttributes.ageing$getBatMode()) {
            event.setCanceled(true);
        }
    }
}

