/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.config;

import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfig {
    public static ModConfigSpec COMMON_CONFIG;
    public static final ModConfigSpec.BooleanValue deathReset;
    public static final ModConfigSpec.BooleanValue advancedVampireAge;
    public static final ModConfigSpec.BooleanValue drainBloodAction;
    public static final ModConfigSpec.BooleanValue celerityAction;
    public static final ModConfigSpec.BooleanValue doesAgeAffectPrices;
    public static final ModConfigSpec.BooleanValue harsherOutOfBlood;
    public static final ModConfigSpec.BooleanValue sireingMechanic;
    public static final ModConfigSpec.BooleanValue ageWaterWalking;
    public static final ModConfigSpec.BooleanValue shouldAgeIncreaseHunterMobDamage;
    public static final ModConfigSpec.BooleanValue vampirePowderedSnowImmunity;
    public static final ModConfigSpec.BooleanValue shouldAgeAffectExhaustion;
    public static final ModConfigSpec.BooleanValue rageModeWeaknessToggle;
    public static final ModConfigSpec.BooleanValue shouldAgeAffectHealing;
    public static final ModConfigSpec.BooleanValue shouldOnlyDieFromKillingSources;
    public static final ModConfigSpec.BooleanValue deadlySourcesFastDrainExhaustion;
    public static final ModConfigSpec.BooleanValue immortalBloodLoss;
    public static final ModConfigSpec.BooleanValue lordLevelRequirement;
    public static final ModConfigSpec.BooleanValue vampireAgeing;
    public static final ModConfigSpec.IntValue ageWaterWalkingRank;
    public static final ModConfigSpec.IntValue lordLevelRankRequirement;
    public static final ModConfigSpec.IntValue levelToBeginAgeMechanic;
    public static final ModConfigSpec.IntValue stepAssistBonus;
    public static final ModConfigSpec.IntValue drainBloodActionDuration;
    public static final ModConfigSpec.IntValue drainBloodActionCooldown;
    public static final ModConfigSpec.IntValue drainBloodActionRank;
    public static final ModConfigSpec.IntValue celerityActionDuration;
    public static final ModConfigSpec.IntValue pettyHuntWorth;
    public static final ModConfigSpec.IntValue commonHuntWorth;
    public static final ModConfigSpec.IntValue greaterHuntWorth;
    public static final ModConfigSpec.IntValue celerityActionCooldown;
    public static final ModConfigSpec.IntValue celerityActionRank;
    public static final ModConfigSpec.IntValue shouldOnlyDieFromKillingSourcesAgeRank;
    public static final ModConfigSpec.IntValue ageLossDBNO;
    public static final ModConfigSpec.IntValue bloodlossDamageThreshold;
    public static final ModConfigSpec.DoubleValue bloodlossScaleFactor;
    public static final ModConfigSpec.IntValue bloodlossDamageCap;
    public static final ModConfigSpec.DoubleValue celerityActionMultiplier;
    public static final ModConfigSpec.ConfigValue<String> ageingMethod;
    public static final ModConfigSpec.IntValue waterWalkingDuration;
    public static final ModConfigSpec.IntValue waterWalkingCooldown;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> sunDamageReduction;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> percentageAdvancedVampireAges;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> genericVampireWeaknessReduction;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> ageExhaustionEffect;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> maxHealthIncrease;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> ageAffectTradePrices;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> ageDamageIncrease;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> ageHealingMultiplier;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> damageMultiplierFromHunters;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> DBNOTimeMultiplier;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> neonatalTimeMultiplier;
    public static final ModConfigSpec.ConfigValue<List<? extends Double>> amountExhaustionDrainFromSources;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> ticksForNextAge;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> drainedBloodForNextAge;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> huntedForNextAge;
    public static final ModConfigSpec.ConfigValue<List<? extends Integer>> infectedForNextAge;

    static {
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        COMMON_BUILDER.push("Generic Values");
        deathReset = COMMON_BUILDER.comment("Whether dying resets Age").define("deathReset", true);
        lordLevelRequirement = COMMON_BUILDER.comment("If enabled, ageing will require the player to be of a specified lord level").define("lordLevelRequirement", false);
        lordLevelRankRequirement = COMMON_BUILDER.comment("If lordLeveLRequirement is enabled, this defines the minimum lord level required to age").defineInRange("lordLevelRankRequirement", 5, 1, 5);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Vampire Values");
        vampireAgeing = COMMON_BUILDER.comment("Whether vampires can age.").define("vampireAgeing", true);
        levelToBeginAgeMechanic = COMMON_BUILDER.comment("The level at which the age mechanic begins, Level 4 is the minimum age to have access to the Infect Action").defineInRange("levelToBeginAgeMechanic", 14, 0, 14);
        ageingMethod = COMMON_BUILDER.comment("Change to select Ageing type. Valid Options include: BITING, DRAINING, TIME, V_HUNTING").define("ageingMethod", (Object)"DRAINING");
        sireingMechanic = COMMON_BUILDER.comment("Intended to be a replacement for other forms of ageing, though will work with them. Overrides the mechanic to always begin at Level 1. Ranks can be gained by drinking blood of more powerful vampires. Highly recommended to turn off Death Reset and to make sure Advanced Vampire Age is turned on. More information on GitHub Readme or Curseforge Page").define("sireingMechanic", false);
        pettyHuntWorth = COMMON_BUILDER.comment("How much a petty hunt is worth. These are things like basic versions of vampires or hunters").defineInRange("pettyHuntWorth", 1, 0, 99);
        commonHuntWorth = COMMON_BUILDER.comment("How much a common hunt is worth. These are things like advanced vampires or advanced hunters").defineInRange("commonHuntWorth", 3, 0, 99);
        greaterHuntWorth = COMMON_BUILDER.comment("How much a greater hunt is worth. These are things like vampire barons ").defineInRange("greaterHuntWorth", 5, 0, 99);
        huntedForNextAge = COMMON_BUILDER.comment("How many points worth of hunted entities are needed to increase Age Rank. Count is reset on Rank Up").defineList("huntedforNextAge", Arrays.asList(20, 40, 80, 160, 250), it -> true);
        vampirePowderedSnowImmunity = COMMON_BUILDER.comment("Whether vampires should be immune to the effects of Powdered Snow. Applies to ALL vampires").define("powderedSnowImmunity", true);
        ageWaterWalking = COMMON_BUILDER.comment("Whether high Age Rank vampires can walk on water").define("ageWaterWalking", true);
        ageWaterWalkingRank = COMMON_BUILDER.comment("Age rank a vampire must be to walk on water").defineInRange("ageWaterWalkingRank", 4, 0, 5);
        waterWalkingCooldown = COMMON_BUILDER.comment("Cooldown for water walking action").defineInRange("waterWalkingCooldown", 0, 0, Integer.MAX_VALUE);
        waterWalkingDuration = COMMON_BUILDER.comment("Duration for water walking action").defineInRange("waterWalkingDuration", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        celerityActionRank = COMMON_BUILDER.comment("What Age Rank a vampire must be to use the Celerity Action").defineInRange("celerityActionRank", 1, 0, 5);
        celerityActionCooldown = COMMON_BUILDER.comment("Cooldown of the Celerity action in seconds").defineInRange("celerityActionCooldown", 60, 20, 36000);
        celerityActionMultiplier = COMMON_BUILDER.comment("Speed Multiplier provided by Celerity Action").defineInRange("celerityActionMultiplier", 1.025, 1.0, 5.0);
        celerityActionDuration = COMMON_BUILDER.comment("Duration of the Celerity action in seconds").defineInRange("celerityActionDuration", 8, 1, 36000);
        celerityAction = COMMON_BUILDER.comment("Whether the Celerity action is available for Aged Vampires").define("celerityAction", true);
        drainBloodActionRank = COMMON_BUILDER.comment("What Age Rank a vampire must be to use the Blood Tap Action").defineInRange("drainBloodActionRank", 3, 0, 5);
        drainBloodActionCooldown = COMMON_BUILDER.comment("Cooldown of the Blood Tap action in seconds").defineInRange("drainBloodActionCooldown", 150, 1, 36000);
        drainBloodActionDuration = COMMON_BUILDER.comment("Duration of the Blood Tap action in seconds").defineInRange("drainBloodActionDuration", 10, 1, 36000);
        drainBloodAction = COMMON_BUILDER.comment("Whether the Blood Tap action is available for Aged Vampires").define("drainBloodAction", true);
        COMMON_BUILDER.comment("For any config with a list of 6 numbers, the very first number refers to a vampire with no age rank and the second number is the first age rank.");
        advancedVampireAge = COMMON_BUILDER.comment("Whether Advanced Vampires should spawn with an Age Tier").define("advancedVampireAge", true);
        percentageAdvancedVampireAges = COMMON_BUILDER.comment("The percentage, as a decimal, of how likely an advanced vampire is to get each rank with advanced vampire ages enabled").defineList("percentageAdvancedVampireAges", Arrays.asList(0.5, 0.3, 0.1, 0.06, 0.03, 0.01), it -> true);
        maxHealthIncrease = COMMON_BUILDER.comment("Max Health Increase for each rank. This is addition, not multiplier based").defineList("maxHealthIncrease", Arrays.asList(0.0, 2.0, 2.0, 3.0, 4.0, 5.0), t -> true);
        doesAgeAffectPrices = COMMON_BUILDER.comment("Whether Age makes a difference on Trade Prices").define("doesAgeAffectPrices", true);
        harsherOutOfBlood = COMMON_BUILDER.comment("Makes running out of blood harsher on vampire, scaling with age").define("harsherOutOfBlood", false);
        ageAffectTradePrices = COMMON_BUILDER.comment("How much each rank affects Villager trade prices. ").defineList("ageAffectTradePrices", Arrays.asList(1.0, 1.1, 1.25, 1.5, 1.75, 2.0), t -> true);
        rageModeWeaknessToggle = COMMON_BUILDER.comment("If enabled, vampire rage will nullify increased damage from generic vampire weakness reduction").define("rageModeWeaknessToggle", true);
        genericVampireWeaknessReduction = COMMON_BUILDER.comment("How much each rank reduces/increases generic vampire weakness damage sources (such as Fire) in terms of how much the damage is divided by. Set all to 1 to have no change, use decimal values to increase damage").defineList("genericVampireWeaknessReduction", Arrays.asList(1.0, 1.0, 0.95, 0.9, 0.8, 0.75), it -> true);
        sunDamageReduction = COMMON_BUILDER.comment("How much each rank reduces/increases Sun Damage in terms of how much the sun damage is divided by. Set all to 1 to have no change, use decimal values to increase sun damage").defineList("sunDamageReduction", Arrays.asList(1.0, 1.25, 1.5, 1.75, 2.0, 2.5), it -> true);
        ticksForNextAge = COMMON_BUILDER.comment("How much time in ticks for a player to advance to the next Age Rank. Count is reset on Rank Up").defineList("ticksForNextAge", Arrays.asList(72000, 144000, 288000, 576000, 1152000), it -> true);
        infectedForNextAge = COMMON_BUILDER.comment("How many entities infected for next Age Rank. Count is reset on Rank Up").defineList("infectedForNextAge", Arrays.asList(30, 45, 70, 100, 200), it -> true);
        drainedBloodForNextAge = COMMON_BUILDER.comment("How much blood drained for next Age Rank. Count is reset on Rank Up").defineList("drainedBloodForNextAge", Arrays.asList(150, 300, 600, 900, 1250), it -> true);
        ageDamageIncrease = COMMON_BUILDER.comment("How much each age rank increases damage by adding on to base damage. Set all to 0 to disable completely.").defineList("ageDamageIncrease", Arrays.asList(0.0, 1.0, 1.5, 2.0, 3.0, 4.0), it -> true);
        stepAssistBonus = COMMON_BUILDER.comment("The Age Rank at which a vampire gains step assist. Set to 0 to disable. ").defineInRange("stepAssistLevel", 2, 0, 6);
        shouldAgeAffectExhaustion = COMMON_BUILDER.comment("Whether Age affects Blood Exhaustion").define("ageAffectsBloodExhaustion", true);
        ageExhaustionEffect = COMMON_BUILDER.comment("How much each rank affects Blood Exhaustion Rate (Blood Drain), lower numbers are a lower decrease in exhaustion, higher numbers decrease exhaustion, values above 1 will cause 0 blood drain. Set all to 0 to have no change in exhaustion rate. Negative Numbers can be used for inverse effect").defineList("ageExhaustionEffect", Arrays.asList(-0.0, -0.1, -0.2, -0.3, -0.4, -0.5), it -> true);
        shouldAgeAffectHealing = COMMON_BUILDER.comment("Whether Age Rank affects healing").define("ageHealingAffect", false);
        ageHealingMultiplier = COMMON_BUILDER.comment("How much each rank multiplies healing, this affects all types of healing ").defineList("ageHealingMultiplier", Arrays.asList(1.0, 1.0, 1.0, 1.5, 1.75, 2.0), it -> true);
        shouldAgeIncreaseHunterMobDamage = COMMON_BUILDER.comment("Whether Age Rank affects how much damage Hunter mobs do").define("shouldAgeIncreaseHunterMobDamage", true);
        damageMultiplierFromHunters = COMMON_BUILDER.comment("How much each rank multiplies damage from hunters, this only affects damage from hunter mobs, not players").defineList("damageMultiplierFromHunters", Arrays.asList(1.0, 1.0, 1.0, 1.5, 1.75, 2.0), it -> true);
        DBNOTimeMultiplier = COMMON_BUILDER.comment("How much each rank multiplies the time spent in DBNO. Decimal values decrease the time spent in DBNO ").defineList("DBNOTimeMultiplier", Arrays.asList(1.0, 1.0, 1.0, 0.8, 0.5, 0.25), it -> true);
        neonatalTimeMultiplier = COMMON_BUILDER.comment("How much each rank multiplies the duration of the neonatal effect. Decimal values decrease the time spent in neonatal").defineList("neonatalTimeMultiplier", Arrays.asList(1.0, 1.0, 1.0, 1.0, 0.75, 0.5), it -> true);
        shouldOnlyDieFromKillingSources = COMMON_BUILDER.comment("If enabled, (and the vampire meets the age rank requirement) a vampire will not go down when losing all of its health, it has to die from a deadly source of damage").define("shouldOnlyDieFromKillingSources", false);
        shouldOnlyDieFromKillingSourcesAgeRank = COMMON_BUILDER.comment("The age rank at which shouldOnlyDieFromKillingSources activates at").defineInRange("shouldOnlyDieFromKillingSourcesAgeRank", 4, 0, 5);
        immortalBloodLoss = COMMON_BUILDER.comment("If this and should only die from killing sources is enabled, the player will lose some blood when taking damage. If they have no blood left they will no longer be immortal").define("immortalityBloodRequirement", false);
        bloodlossDamageThreshold = COMMON_BUILDER.comment("Minimum damage for bloodloss to begin happening with 'immortalBloodLoss' enabled").defineInRange("bloodlossDamageThreshold", 1, 0, 100);
        bloodlossDamageCap = COMMON_BUILDER.comment("Maximum damage for bloodloss with immortalBloodLoss' enabled").defineInRange("bloodlossDamageCap", 16, 0, 100);
        bloodlossScaleFactor = COMMON_BUILDER.comment("How much the damage is multiplied to get bloodloss amount 'immortalBloodLoss' enabled").defineInRange("bloodlossScaleFactor", 1.0, 0.0, 100.0);
        deadlySourcesFastDrainExhaustion = COMMON_BUILDER.comment("Garlic and fire will quickly drain them of blood saturation").define("deadlySourcesFastDrainExhaustion", true);
        amountExhaustionDrainFromSources = COMMON_BUILDER.comment("How much extra exhaustion there is of each garlic and fire tick at each age rank").defineList("amountExhaustionDrainFromSources", Arrays.asList(0.0, 0.0, 0.0, 0.08, 0.16, 0.3), it -> true);
        ageLossDBNO = COMMON_BUILDER.comment("How many ranks of age are lost after resurrecting from DBNO").defineInRange("ageLossDBNO", 1, 0, 5);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

