/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.items;

import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.HunterAgeingType;
import com.thedrofdoctoring.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaintedElixirItem
extends Item
implements IFactionExclusiveItem {
    public TaintedElixirItem(Item.Properties props) {
        super(props);
    }

    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack itemStack) {
        return VReference.HUNTER_FACTION;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!((Boolean)HunterAgeingConfig.permanentTransformationAvailable.get()).booleanValue()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!Helper.isHunter((Player)player)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        int age = AgeingManager.getAge(player).getAge();
        if (age >= 5) {
            player.startUsingItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack stack, int count) {
        if (pLivingEntity instanceof IHunterPlayer) {
            return;
        }
        if (!(pLivingEntity instanceof Player && pLivingEntity.isAlive() && ((Boolean)HunterAgeingConfig.permanentTransformationAvailable.get()).booleanValue())) {
            pLivingEntity.releaseUsingItem();
            return;
        }
        Player player = (Player)pLivingEntity;
        int age = AgeingManager.getAge(player).getAge();
        if (age >= 5) {
            pLivingEntity.startUsingItem(pLivingEntity.getUsedItemHand());
        }
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof Player && Helper.isHunter((Entity)entityLiving)) {
            Player player = (Player)entityLiving;
            AgeingManager ageingManager = AgeingManager.getAge(player);
            ((HunterAgeingType.HunterState)ageingManager.getTypeState()).setTransformed(true);
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 1));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.PLAYERS, 1.0f, 1.0f);
            ModParticles.spawnParticlesServer((Level)player.level(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"spell_1"), 50, 0x8B0000, 0.2f), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)100, (double)1.0, (double)1.0, (double)1.0, (double)0.0);
            stack.shrink(1);
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entityLiving;
                ageingManager.getType().handleSkills(ageingManager.getAge(), sp);
            }
        }
        return super.finishUsingItem(stack, worldIn, entityLiving);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"text.vampiricageing.tainted_elixir_useage", (Object[])new Object[]{5}).withStyle(ChatFormatting.RED));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 45;
    }
}

