/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CrossSideManager;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.natives.NativeUtils;

public abstract class NativeValidator {
    private NativeState state = NativeState.NOT_INITIALIZED;

    protected abstract void runValidation() throws Throwable;

    protected abstract String getNativeName();

    public void initialize() {
        if (this.state.isInitialized()) {
            return;
        }
        if (!CrossSideManager.get().useNatives()) {
            Voicechat.LOGGER.info("Skipping initialization of {} - Natives are disabled", this.getNativeName());
            this.state = NativeState.failed("Natives are disabled");
            return;
        }
        if (Platform.isMac() && !VersionCheck.isMacOSNativeCompatible()) {
            Voicechat.LOGGER.info("Skipping initialization of {} - Unsupported macOS version", this.getNativeName());
            this.state = NativeState.failed("Unsupported macOS version");
            return;
        }
        Voicechat.LOGGER.info("Initializing {}", this.getNativeName());
        Boolean success = NativeUtils.createSafe(() -> {
            this.runValidation();
            return true;
        }, e -> {
            Voicechat.LOGGER.warn("Failed to validate {}", this.getNativeName(), e);
            this.state = NativeState.failed(e.getMessage());
        });
        if (success == null || !success.booleanValue()) {
            if (!this.state.isInitialized()) {
                this.state = NativeState.failed("Unknown error");
            }
            return;
        }
        this.state = NativeState.SUCCESS;
        Voicechat.LOGGER.info("Successfully initialized {}", this.getNativeName());
    }

    public void setFailed(String message) {
        this.state = NativeState.failed(message);
    }

    public boolean canUse() {
        if (!this.state.isInitialized()) {
            this.initialize();
        }
        return this.state.isSuccess();
    }

    public String getMessage() {
        return this.state.getMessage();
    }

    protected static class NativeState {
        public static final NativeState NOT_INITIALIZED = NativeState.notInitialized();
        public static final NativeState SUCCESS = NativeState.success();
        private final NativeLoadState state;
        private final String message;

        private NativeState(NativeLoadState state, String message) {
            this.state = state;
            this.message = message;
        }

        private static NativeState notInitialized() {
            return new NativeState(NativeLoadState.NOT_INITIALIZED, "");
        }

        private static NativeState success() {
            return new NativeState(NativeLoadState.SUCCESS, "");
        }

        public static NativeState failed(String message) {
            return new NativeState(NativeLoadState.FAILED, message);
        }

        public NativeLoadState getState() {
            return this.state;
        }

        public boolean isInitialized() {
            return !NativeLoadState.NOT_INITIALIZED.equals((Object)this.state);
        }

        public boolean isSuccess() {
            return NativeLoadState.SUCCESS.equals((Object)this.state);
        }

        public boolean isFailed() {
            return NativeLoadState.FAILED.equals((Object)this.state);
        }

        public String getMessage() {
            return this.message;
        }
    }

    protected static enum NativeLoadState {
        NOT_INITIALIZED,
        SUCCESS,
        FAILED;

    }
}

