/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.downloader.client;

import org.watermedia.shaded.fastjson.JSONObject;

public interface Client {
    public static Client of(final String name, final String version, final JSONObject body, QueryParameter ... parameters) {
        JSONObject client = body.getJSONObject("context").getJSONObject("client");
        client.fluentPut("clientName", name);
        client.fluentPut("clientVersion", version);
        JSONObject cur = body;
        for (QueryParameter param : parameters) {
            for (String p : param.path) {
                cur = cur.getJSONObject(p);
            }
            cur.fluentPut(param.key, param.value);
        }
        return new Client(){
            final String n;
            final String v;
            final String b;
            final JSONObject j;
            {
                this.n = name;
                this.v = version;
                this.b = body.toJSONString();
                this.j = body;
            }

            @Override
            public String getName() {
                return this.n;
            }

            @Override
            public String getVersion() {
                return this.v;
            }

            @Override
            public JSONObject getBody() {
                return this.j;
            }

            @Override
            public String getBodyString() {
                return this.b;
            }
        };
    }

    public static Client of(String name, String version, JSONObject body) {
        return Client.of(name, version, body, new QueryParameter[0]);
    }

    public String getName();

    public String getVersion();

    public String getBodyString();

    public JSONObject getBody();

    public static JSONObject baseJson() {
        JSONObject client = new JSONObject().fluentPut("hl", "en").fluentPut("gl", "US");
        JSONObject context = new JSONObject().fluentPut("client", client);
        return new JSONObject().fluentPut("context", context);
    }

    public static QueryParameter queryParam(String path, String key, String value) {
        return new QueryParameter(path, key, value);
    }

    public static QueryParameter queryParam(String key, String value) {
        return new QueryParameter(key, value);
    }

    public static class QueryParameter {
        final String[] path;
        final String value;
        final String key;

        QueryParameter(String path, String key, String value) {
            this.path = path.split("/");
            this.value = value;
            this.key = key;
        }

        QueryParameter(String key, String value) {
            this("", key, value);
        }
    }
}

