/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.tools;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.videolan4j.VideoLan4J;
import sun.misc.Unsafe;

public class Buffers {
    private static final Marker IT = MarkerManager.getMarker((String)Buffers.class.getSimpleName());
    private static final Unsafe UNSAFE;
    private static final long ADDRESS_FIELD_OFFSET;
    private static BiFunction<Integer, Integer, ByteBuffer> BUFFER_ALLOCATOR;
    private static Consumer<ByteBuffer> BUFFER_DEALLOCATOR;

    public static void setBufferAllocator(BiFunction<Integer, Integer, ByteBuffer> bufferAllocator) {
        BUFFER_ALLOCATOR = bufferAllocator;
    }

    public static void setBufferDeallocator(Consumer<ByteBuffer> bufferDeallocator) {
        BUFFER_DEALLOCATOR = bufferDeallocator;
    }

    public static ByteBuffer alloc(int size) {
        ByteBuffer buffer = BUFFER_ALLOCATOR.apply(32, size);
        if (Buffers.isUnaligned(Buffers.address(buffer))) {
            VideoLan4J.LOGGER.warn(IT, "Buffer address {} with size {} is unaligned, this might lead in performance issues", (Object)Buffers.address(buffer), (Object)size);
        }
        return buffer;
    }

    public static void dealloc(ByteBuffer buffer) {
        BUFFER_DEALLOCATOR.accept(buffer);
    }

    private static void dealloc1(ByteBuffer buffer) {
    }

    private static ByteBuffer alloc1(int alignment, int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(alignment + size);
        long address = Buffers.address(buffer);
        return Buffers.align(buffer, address, size);
    }

    public static boolean isUnaligned(long address) {
        return (address & 0x1FL) != 0L;
    }

    private static ByteBuffer align(ByteBuffer buffer, long address, int size) {
        if (Buffers.isUnaligned(address)) {
            int newPosition = (int)(32L - (address & 0x1FL));
            buffer.position(newPosition);
            size += newPosition;
        }
        ByteBuffer result = buffer.limit(size);
        return result.slice().order(ByteOrder.nativeOrder());
    }

    public static long address(ByteBuffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    public static long address(Buffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static {
        BUFFER_ALLOCATOR = Buffers::alloc1;
        BUFFER_DEALLOCATOR = Buffers::dealloc1;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

