/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.various.items;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.AdvancedConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.utils.I18nConstants;
import mcjty.xnet.utils.I18nUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ConnectorUpgradeItem
extends Item {
    public ConnectorUpgradeItem() {
        super(XNet.setup.defaultProperties());
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        for (String part : I18nUtils.getSplitedTooltip(I18nConstants.CONNECTOR_UPGRADE.i18n(new Object[0]))) {
            tooltip.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.BLUE) + part)));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand hand) {
        return super.use(worldIn, playerIn, hand);
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        Player player = context.getPlayer();
        Block block = state.getBlock();
        if (block == CableModule.CONNECTOR.get()) {
            BlockEntity te;
            if (!world.isClientSide && (te = world.getBlockEntity(pos)) instanceof ConnectorTileEntity) {
                CompoundTag tag = te.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
                CableColor color = (CableColor)((Object)world.getBlockState(pos).getValue(GenericCableBlock.COLOR));
                XNetBlobData blobData = XNetBlobData.get(world);
                WorldBlob worldBlob = blobData.getWorldBlob(world);
                ConsumerId consumer = worldBlob.getConsumerAt(pos);
                ((ConnectorBlock)block).unlinkBlock(world, pos);
                world.setBlockAndUpdate(pos, (BlockState)((AdvancedConnectorBlock)((Object)CableModule.ADVANCED_CONNECTOR.get())).defaultBlockState().setValue(GenericCableBlock.COLOR, (Comparable)((Object)color)));
                BlockState blockState = world.getBlockState(pos);
                ((ConnectorBlock)blockState.getBlock()).createCableSegment(world, pos, consumer);
                blockState = ((ConnectorBlock)block).calculateState((LevelAccessor)world, pos, blockState);
                world.setBlock(pos, blockState, 3);
                player.getInventory().removeItem(player.getInventory().selected, 1);
                player.containerMenu.broadcastChanges();
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + I18nConstants.CONNECTOR_WAS_UPGRADED.i18n(new Object[0]))), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (block == CableModule.ADVANCED_CONNECTOR.get()) {
            if (!world.isClientSide) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + I18nConstants.CONNECTOR_ALREADY_ADVANCED.i18n(new Object[0]))), false);
            }
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide) {
            player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + I18nConstants.CONNECTOR_USE_IT_TO_UPGRADE.i18n(new Object[0]))), false);
        }
        return InteractionResult.SUCCESS;
    }
}

