/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.blockentity;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider {
    protected final int MAX_DIST_SQRT = 64;
    @NotNull
    protected NonNullList<ItemStack> inventorySlots;
    protected InventoryContainerMenu.SelectorInfo[] selectors;

    public InventoryBlockEntity(@NotNull BlockEntityType<?> tileEntityTypeIn, @NotNull BlockPos pos, @NotNull BlockState state, ItemCombinerMenuSlotDefinition slotDefinition) {
        this(tileEntityTypeIn, pos, state, slotDefinition.getNumOfInputSlots(), (InventoryContainerMenu.SelectorInfo[])slotDefinition.getSlots().stream().map(d -> new InventoryContainerMenu.SelectorInfo(d.mayPlace(), d.x(), d.y())).toArray(InventoryContainerMenu.SelectorInfo[]::new));
    }

    public InventoryBlockEntity(@NotNull BlockEntityType<?> tileEntityTypeIn, @NotNull BlockPos pos, @NotNull BlockState state, int size, InventoryContainerMenu.SelectorInfo ... selectorInfos) {
        super(tileEntityTypeIn, pos, state);
        this.inventorySlots = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        if (selectorInfos.length != size) {
            throw new IllegalArgumentException("Selector count must match inventory size");
        }
        this.selectors = selectorInfos;
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        if (slot < 0 || slot >= this.selectors.length) {
            return false;
        }
        return this.selectors[slot].validate(stack);
    }

    public void clearContent() {
        this.inventorySlots.clear();
    }

    public int getContainerSize() {
        return this.inventorySlots.size();
    }

    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.inventorySlots.get(index);
    }

    public boolean isEmpty() {
        return this.inventorySlots.isEmpty();
    }

    protected void setItems(NonNullList<ItemStack> newInventory) {
        this.inventorySlots = newInventory;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventorySlots;
    }

    public void loadAdditional(@NotNull CompoundTag tagCompound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tagCompound, lookupProvider);
        this.inventorySlots.clear();
        ContainerHelper.loadAllItems((CompoundTag)tagCompound, this.inventorySlots, (HolderLookup.Provider)lookupProvider);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amt) {
        return ContainerHelper.removeItem(this.inventorySlots, (int)slot, (int)amt);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.inventorySlots, (int)index);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(pTag, lookupProvider);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.inventorySlots, (HolderLookup.Provider)lookupProvider);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.inventorySlots.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void startOpen(@NotNull Player player) {
    }

    public boolean stillValid(@NotNull Player player) {
        if (!this.hasLevel()) {
            return false;
        }
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    protected boolean isFull() {
        for (ItemStack s : this.inventorySlots) {
            if (!s.isEmpty() && s.getCount() >= s.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public static class SelectorInvWrapper
    extends InvWrapper {
        public SelectorInvWrapper(InventoryBlockEntity inv) {
            super((Container)inv);
        }

        public int getSlotLimit(int slot) {
            return slot < 0 || slot >= ((InventoryBlockEntity)this.getInv()).selectors.length ? 0 : ((InventoryBlockEntity)this.getInv()).selectors[slot].stackLimit;
        }
    }
}

