/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.util.SkillCallbacks;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultAction<T extends IFactionPlayer<T>>
implements IAction<T> {
    private String translationId;

    public void addEffectInstance(@NotNull T player, @NotNull MobEffectInstance instance) {
        ((EffectInstanceWithSource)instance).setSource(this.getRegistryName());
        player.asEntity().addEffect(instance);
    }

    public boolean canBeUsedBy(T player) {
        return true;
    }

    @Override
    public final @NotNull IAction.PERM canUse(@NotNull T player) {
        if (!this.isEnabled()) {
            return IAction.PERM.DISABLED;
        }
        if (this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            return this.canBeUsedBy(player) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + String.valueOf(player.getClass()) + " instead of " + String.valueOf(this.getFaction().get().getFactionPlayerInterface()));
    }

    @Override
    @Deprecated
    @NotNull
    public String getTranslationKey() {
        if (this.translationId == null) {
            this.translationId = Util.makeDescriptionId((String)"action", (ResourceLocation)VampirismRegistries.ACTION.get().getKey((Object)this));
        }
        return this.translationId;
    }

    public abstract boolean isEnabled();

    @Override
    public boolean onActivated(@NotNull T player, IAction.ActivationContext context) {
        if (this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            return this.activate(player, context);
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + String.valueOf(player.getClass()) + " instead of " + String.valueOf(this.getFaction().get().getFactionPlayerInterface()));
    }

    public void removePotionEffect(@NotNull T player, @NotNull Holder<MobEffect> effect) {
        MobEffectInstance ins = player.asEntity().getEffect(effect);
        while (ins != null) {
            EffectInstanceWithSource insM = (EffectInstanceWithSource)ins;
            if (insM.hasSource() && insM.getSource().equals((Object)this.getRegistryName())) {
                insM.removeEffect();
                break;
            }
            ins = insM.getHiddenEffect();
        }
    }

    @Override
    public ISkill<T> asSkill() {
        return SkillCallbacks.getActionSkillMap().get(this);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getRegistryName()) + " (" + this.getClass().getSimpleName() + ")";
    }

    protected abstract boolean activate(T var1, IAction.ActivationContext var2);

    @Nullable
    private ResourceLocation getRegistryName() {
        return VampirismRegistries.ACTION.get().getKey((Object)this);
    }
}

