/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public interface IItemWithTier
extends ItemLike {
    default public void addTierInformation(@NotNull List<Component> tooltip) {
        TIER t = this.getVampirismTier();
        if (t != TIER.NORMAL) {
            ChatFormatting format = t == TIER.ENHANCED ? ChatFormatting.YELLOW : ChatFormatting.AQUA;
            tooltip.add((Component)Component.translatable((String)("item.vampirism.item.tier." + t.getSerializedName().toLowerCase())).withStyle(format));
        }
    }

    public TIER getVampirismTier();

    public static enum TIER implements StringRepresentable
    {
        NORMAL("normal"),
        ENHANCED("enhanced"),
        ULTIMATE("ultimate");

        private final String name;

        private TIER(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.getSerializedName();
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

