/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampireLeveling;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.fluids.BloodFluid;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleOptions;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class AltarInspirationBlockEntity
extends BlockEntity
implements FluidTankWithListener.IFluidTankListener {
    public static final int CAPACITY = 10000;
    public static final ModelProperty<Integer> FLUID_LEVEL_PROP = new ModelProperty();
    private static final int RITUAL_TIME = 60;
    private int ritualTicksLeft = 0;
    private int targetLevel;
    private Player ritualPlayer;
    private ModelData modelData;
    private final FluidTankWithListener tank = new InternalTank(10000).setListener(this);

    public static void setBloodValue(@NotNull BlockGetter worldIn, @NotNull Random randomIn, @NotNull BlockPos blockPosIn) {
        BlockEntity tileEntity = worldIn.getBlockEntity(blockPosIn);
        if (tileEntity instanceof AltarInspirationBlockEntity) {
            ((AltarInspirationBlockEntity)tileEntity).getTank().fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), BloodBottleFluidHandler.getAdjustedAmount((int)(10000.0f * randomIn.nextFloat()))), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public AltarInspirationBlockEntity(@NotNull BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.ALTAR_INSPIRATION.get(), pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        if (this.modelData == null) {
            this.updateModelData(false);
        }
        return this.modelData;
    }

    public FluidTankWithListener getTank() {
        return this.tank;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        if (!this.hasLevel()) {
            return;
        }
        FluidStack old = this.tank.getFluid();
        CompoundTag tag = pkt.getTag();
        this.loadCustomOnly(tag, lookupProvider);
        if (!FluidStack.isSameFluidSameComponents((FluidStack)old, (FluidStack)this.tank.getFluid())) {
            this.updateModelData(true);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.setChanged();
    }

    public void setChanged() {
        if (this.level != null) {
            if (this.level.isClientSide) {
                this.updateModelData(true);
            }
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
            super.setChanged();
        }
    }

    public void startRitual(@NotNull Player p) {
        if (this.ritualTicksLeft > 0 || !p.isAlive()) {
            return;
        }
        this.targetLevel = VampirismPlayerAttributes.get((Player)p).vampireLevel + 1;
        Optional<VampireLeveling.AltarInspirationRequirement> requirement = VampireLeveling.getInspirationRequirement(this.targetLevel);
        if (requirement.isEmpty()) {
            if (p.level().isClientSide) {
                p.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual_level_wrong"), true);
            }
            return;
        }
        int neededBlood = requirement.get().bloodAmount() * 100;
        if (this.tank.getFluidAmount() + 99 < neededBlood) {
            p.displayClientMessage((Component)Component.translatable((String)"text.vampirism.not_enough_blood"), true);
            return;
        }
        if (!p.level().isClientSide) {
            ModParticles.spawnParticlesServer(p.level(), new FlyingBloodEntityParticleOptions(p.getId(), false), (double)this.worldPosition.getX() + 0.5, this.worldPosition.getY() + 1, (double)this.worldPosition.getZ() + 0.5, 40, 0.1f, 0.1f, 0.1f, 0.0);
        } else {
            ((InternalTank)this.tank).doDrain(neededBlood, IFluidHandler.FluidAction.EXECUTE);
        }
        this.setChanged();
        this.ritualPlayer = p;
        this.ritualTicksLeft = 60;
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull AltarInspirationBlockEntity blockEntity) {
        if (blockEntity.ritualTicksLeft == 0 || blockEntity.ritualPlayer == null || !blockEntity.ritualPlayer.isAlive()) {
            return;
        }
        switch (blockEntity.ritualTicksLeft) {
            case 5: {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
                lightningboltentity.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                lightningboltentity.setVisualOnly(true);
                level.addFreshEntity((Entity)lightningboltentity);
                blockEntity.ritualPlayer.setHealth(blockEntity.ritualPlayer.getMaxHealth());
                break;
            }
            case 1: {
                Optional<VampireLeveling.AltarInspirationRequirement> req = VampireLeveling.getInspirationRequirement(blockEntity.targetLevel);
                int blood = req.map(VampireLeveling.AltarInspirationRequirement::bloodAmount).orElse(0) * 100;
                ((InternalTank)blockEntity.tank).doDrain(blood, IFluidHandler.FluidAction.EXECUTE);
                blockEntity.ritualPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, blockEntity.targetLevel * 10 * 20));
                FactionPlayerHandler.get(blockEntity.ritualPlayer).setFactionLevel(VReference.VAMPIRE_FACTION, blockEntity.targetLevel);
                VampirePlayer.get(blockEntity.ritualPlayer).drinkBlood(Integer.MAX_VALUE, 0.0f, false, DrinkBloodContext.none());
            }
        }
        --blockEntity.ritualTicksLeft;
    }

    private void updateModelData(boolean refresh) {
        FluidStack fluid = this.tank.getFluid();
        int l = 0;
        if (!fluid.isEmpty()) {
            float i = (float)fluid.getAmount() / 10000.0f * 10.0f;
            l = i > 0.0f && i < 1.0f ? 1 : (int)i;
        }
        this.modelData = ModelData.builder().with(FLUID_LEVEL_PROP, (Object)l).build();
        if (refresh) {
            this.requestModelDataUpdate();
        }
    }

    public static class InternalTank
    extends FluidTankWithListener {
        private InternalTank(int capacity) {
            super(capacity, fluidStack -> ((BloodFluid)((Object)((Object)ModFluids.BLOOD.get()))).isSame(fluidStack.getFluid()));
            this.setDrainable(false);
        }

        void doDrain(int maxDrain, IFluidHandler.FluidAction action) {
            this.setDrainable(true);
            super.drain(maxDrain, action);
            this.setDrainable(false);
        }
    }
}

