/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffinBlockEntity
extends BlockEntity {
    public float lidPos;
    public DyeColor color = DyeColor.RED;
    private boolean playLidSoundFlag;

    public CoffinBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.COFFIN.get(), pos, state);
    }

    public CoffinBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state, DyeColor color) {
        super((BlockEntityType)ModTiles.COFFIN.get(), pos, state);
        this.color = color;
    }

    public void changeColor(DyeColor color) {
        this.color = color;
        this.setChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.color = compound.contains("color") ? DyeColor.byId((int)compound.getInt("color")) : DyeColor.BLACK;
        this.lidPos = compound.getFloat("lidPos");
        this.playLidSoundFlag = this.lidPos == 0.0f;
    }

    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        if (this.hasLevel()) {
            this.loadCustomOnly(packet.getTag(), provider);
        }
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("color", this.color.getId());
        compound.putFloat("lidPos", this.lidPos);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
        }
    }

    public static void clientTickHead(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull CoffinBlockEntity blockEntity) {
        boolean isClosed;
        boolean occupied = CoffinBlock.isClosed((BlockGetter)level, pos);
        if (blockEntity.playLidSoundFlag != occupied) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), (SoundEvent)ModSounds.COFFIN_LID.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f, true);
            blockEntity.playLidSoundFlag = CoffinBlock.isClosed((BlockGetter)level, pos);
        }
        boolean bl = isClosed = blockEntity.hasLevel() && CoffinBlock.isClosed((BlockGetter)level, pos);
        blockEntity.lidPos = !isClosed ? (blockEntity.lidPos += 0.02f) : (blockEntity.lidPos -= 0.02f);
        blockEntity.lidPos = Mth.clamp((float)blockEntity.lidPos, (float)0.0f, (float)1.0f);
    }
}

