/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.world.LevelFog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FogDiffuserBlockEntity
extends BlockEntity {
    @NotNull
    private State state = State.IDLE;
    private boolean activated = false;
    private float bootProgress = 0.0f;

    public FogDiffuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.FOG_DIFFUSER.get(), pPos, pBlockState);
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        pTag.putString("state", this.state.name());
        pTag.putFloat("bootProgress", this.bootProgress);
        pTag.putBoolean("activated", this.activated);
    }

    public void loadAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.state = State.valueOf(pTag.getString("state"));
        this.bootProgress = pTag.getFloat("bootProgress");
        this.activated = pTag.getBoolean("activated");
    }

    protected int getRange() {
        return 40;
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public float getBootProgress() {
        return this.bootProgress;
    }

    protected AABB getArea() {
        return this.getArea(this.getRange());
    }

    protected AABB getArea(int range) {
        return new AABB(Vec3.atLowerCornerOf((Vec3i)this.worldPosition.offset(-range, -range, -range)), Vec3.atLowerCornerWithOffset((Vec3i)this.worldPosition.offset(range, range, range), (double)1.0, (double)1.0, (double)1.0));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FogDiffuserBlockEntity blockEntity) {
        switch (blockEntity.state.ordinal()) {
            case 0: {
                if (!blockEntity.activated) break;
                blockEntity.state = State.BOOTING;
                blockEntity.bootProgress = 0.0f;
                break;
            }
            case 1: {
                if (level.getGameTime() % 128L != 0L) break;
                blockEntity.bootProgress += 0.1f;
                if (blockEntity.bootProgress >= 1.0f) {
                    blockEntity.state = State.ACTIVE;
                }
                blockEntity.updateFogArea(level);
                break;
            }
        }
    }

    public void setRemoved() {
        this.updateFogArea((AABB)null);
        super.setRemoved();
    }

    public void updateFogArea(Level level) {
        this.updateFogArea(switch (this.state.ordinal()) {
            case 1 -> this.getArea((int)((float)this.getRange() * this.bootProgress));
            case 2 -> this.getArea();
            default -> null;
        });
    }

    protected void updateFogArea(AABB area) {
        LevelFog.getOpt(this.level).ifPresent(fog -> fog.updateArtificialFogBoundingBox(this.worldPosition, area));
    }

    public boolean interact(ItemStack itemInHand) {
        if (!this.activated && itemInHand.is(ModTags.Items.PURE_BLOOD)) {
            this.activated = true;
            itemInHand.shrink(1);
            return true;
        }
        return false;
    }

    public static enum State {
        IDLE,
        BOOTING,
        ACTIVE;

    }
}

