/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.util.DamageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AlchemicalFireBlock
extends VampirismBlock {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)15);

    public AlchemicalFireBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.FIRE).strength(0.0f).lightLevel(s -> 15).sound(SoundType.WOOL).noCollission().randomTicks().noOcclusion().pushReaction(PushReaction.DESTROY).replaceable().noLootTable().isViewBlocking(UtilLib::never));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            SimpleParticleType type = i == 0 ? ParticleTypes.LARGE_SMOKE : (i == 1 ? ParticleTypes.WITCH : (rand.nextInt(10) == 0 ? ParticleTypes.FIREWORK : DustParticleOptions.REDSTONE));
            worldIn.addParticle((ParticleOptions)type, d0, d1, d2, 0.0, i == 2 ? 0.1 : 0.0, 0.0);
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader worldIn, @NotNull BlockPos pos) {
        return worldIn.getBlockState(pos.below()).isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP);
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Entity entityIn) {
        if (!entityIn.fireImmune()) {
            entityIn.igniteForSeconds((float)(entityIn.getRemainingFireTicks() + 1));
            if (entityIn.getRemainingFireTicks() == 0) {
                entityIn.igniteForSeconds(8.0f);
            }
            DamageHandler.hurtVanilla(entityIn, DamageSources::inFire, 1.0f);
        }
        super.entityInside(state, worldIn, pos, entityIn);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)worldIn, pos)) {
            worldIn.removeBlock(pos, isMoving);
        }
    }

    public void setBurningInfinite(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(15)), 4);
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int age;
        if (!this.canSurvive(state, (LevelReader)worldIn, pos)) {
            worldIn.removeBlock(pos, this.hasCollision);
        }
        if ((age = ((Integer)state.getValue((Property)AGE)).intValue()) < 14) {
            state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1));
            worldIn.setBlock(pos, state, 4);
        } else if (age == 14) {
            worldIn.removeBlock(pos, this.hasCollision);
        }
        worldIn.scheduleTick(pos, (Block)this, 30 + random.nextInt(10));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

