/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarCleansingBlock
extends VampirismHorizontalBlock {
    private static final VoxelShape SHAPEX = AltarCleansingBlock.makeShape();
    private static final VoxelShape SHAPEZ = UtilLib.rotateShape(SHAPEX, UtilLib.RotationAmount.NINETY);

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)1.0, (double)12.0);
        VoxelShape b = Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)12.0, (double)11.0);
        VoxelShape c = Block.box((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)14.0, (double)13.0);
        VoxelShape r = Shapes.or((VoxelShape)a, (VoxelShape)b);
        return Shapes.or((VoxelShape)r, (VoxelShape)c);
    }

    public AltarCleansingBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().strength(0.5f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction dir = (Direction)blockState.getValue((Property)FACING);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            return SHAPEX;
        }
        return SHAPEZ;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public String getDescriptionId() {
        return "block.vampirism.church_altar";
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!world.isClientSide || !player.isAlive()) {
            return InteractionResult.PASS;
        }
        if (FactionPlayerHandler.get(player).isInFaction(VReference.VAMPIRE_FACTION)) {
            VampirismMod.proxy.displayRevertBackScreen();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

