/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.AltarInfusionBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AltarInfusionBlock
extends VampirismBlockContainer {
    protected static final VoxelShape altarBase = AltarInfusionBlock.makeShape();
    public static final MapCodec<AltarInfusionBlock> CODEC = AltarInfusionBlock.simpleCodec(AltarInfusionBlock::new);

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
        VoxelShape b = Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
        VoxelShape c = Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
        VoxelShape d1 = Block.box((double)1.0, (double)6.0, (double)1.0, (double)3.0, (double)7.0, (double)15.0);
        VoxelShape d2 = Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)7.0, (double)3.0);
        VoxelShape d3 = Block.box((double)15.0, (double)6.0, (double)3.0, (double)15.0, (double)7.0, (double)15.0);
        VoxelShape d4 = Block.box((double)3.0, (double)6.0, (double)15.0, (double)15.0, (double)7.0, (double)15.0);
        VoxelShape e1 = Block.box((double)1.0, (double)6.0, (double)1.0, (double)3.0, (double)12.0, (double)3.0);
        VoxelShape e2 = Block.box((double)13.0, (double)6.0, (double)1.0, (double)15.0, (double)12.0, (double)3.0);
        VoxelShape e3 = Block.box((double)13.0, (double)6.0, (double)13.0, (double)15.0, (double)12.0, (double)15.0);
        VoxelShape e4 = Block.box((double)1.0, (double)6.0, (double)13.0, (double)3.0, (double)12.0, (double)15.0);
        VoxelShape f1 = Block.box((double)1.0, (double)12.0, (double)1.0, (double)2.0, (double)13.0, (double)2.0);
        VoxelShape f2 = Block.box((double)14.0, (double)12.0, (double)1.0, (double)15.0, (double)13.0, (double)2.0);
        VoxelShape f3 = Block.box((double)1.0, (double)12.0, (double)14.0, (double)2.0, (double)13.0, (double)15.0);
        VoxelShape f4 = Block.box((double)14.0, (double)12.0, (double)14.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape g = Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
        VoxelShape h1 = Block.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
        VoxelShape h2 = Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0);
        VoxelShape h3 = Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d1, d2, d3, d4, e1, e2, e3, e4, f1, f2, f3, f4, g, h1, h2, h3});
    }

    public AltarInfusionBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AltarInfusionBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return altarBase;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState blockState, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        AltarInfusionBlockEntity te = (AltarInfusionBlockEntity)worldIn.getBlockEntity(pos);
        if (worldIn.isClientSide || te == null) {
            return InteractionResult.SUCCESS;
        }
        if (!Helper.isVampire(player)) {
            player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual.wrong_faction"), true);
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            AltarInfusionBlockEntity.Result result = te.canActivate(player);
            switch (result) {
                case ISRUNNING: {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual_still_running"), true);
                    return InteractionResult.SUCCESS;
                }
                case NIGHTONLY: {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual_night_only"), true);
                    return InteractionResult.SUCCESS;
                }
                case STRUCTUREWRONG: {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual_missing_pillars"), true);
                    return InteractionResult.SUCCESS;
                }
                case INVMISSING: {
                    player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual_missing_times"), true);
                    break;
                }
                case OK: {
                    if (!heldItem.isEmpty()) break;
                    player.awardStat((ResourceLocation)ModStats.ALTAR_OF_INFUSION_RITUALS_PERFORMED.get());
                    te.startRitual(player);
                    return InteractionResult.SUCCESS;
                }
            }
            if (te.getCurrentPhase() != AltarInfusionBlockEntity.PHASE.NOT_RUNNING) {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.altar_infusion.ritual_still_running"), true);
                return InteractionResult.SUCCESS;
            }
        }
        player.openMenu((MenuProvider)te);
        player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_ALTAR_OF_INFUSION.get());
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void clearContainer(BlockState state, @NotNull Level worldIn, BlockPos pos) {
        this.dropInventoryTileEntityItems(worldIn, pos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return AltarInfusionBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.ALTAR_INFUSION.get()), AltarInfusionBlockEntity::tick);
    }
}

