/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.blocks.CandleStickBlock;
import de.teamlapen.vampirism.core.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandingCandleStickBlock
extends CandleStickBlock {
    public static final MapCodec<StandingCandleStickBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> StandingCandleStickBlock.candleStickParts(inst).apply((Applicative)inst, StandingCandleStickBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final ImmutableList<Vec3> PARTICLE_OFFSET = ImmutableList.of((Object)new Vec3(0.5, 0.8, 0.5));
    private static final VoxelShape SHAPE = StandingCandleStickBlock.makeShape();
    private static final VoxelShape SHAPE_WITH_CANDLE = StandingCandleStickBlock.makeShapeWithCandle();

    private StandingCandleStickBlock(Block emptyBlock, Item candle, BlockBehaviour.Properties pProperties) {
        this(() -> emptyBlock, () -> candle, pProperties);
    }

    public StandingCandleStickBlock(@Nullable Supplier<? extends Block> emptyBlock, @NotNull Supplier<Item> candle, BlockBehaviour.Properties pProperties) {
        super(emptyBlock, candle, pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ((StandingAndWallBlockItem)ModItems.CANDLE_STICK.get()).getDefaultInstance();
    }

    @Override
    public boolean canSurvive(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).isSolid();
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @Override
    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, @NotNull Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)((Direction)pState.getValue((Property)FACING)).getOpposite());
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pMirror.mirror((Direction)pState.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{FACING}));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.isEmpty() ? SHAPE : SHAPE_WITH_CANDLE;
    }

    protected MapCodec<? extends AbstractCandleBlock> codec() {
        return null;
    }

    @NotNull
    protected Iterable<Vec3> getParticleOffsets(@NotNull BlockState pState) {
        return PARTICLE_OFFSET;
    }

    @Override
    protected BlockState getFilledState(BlockState sourceState, Block block) {
        return (BlockState)super.getFilledState(sourceState, block).setValue((Property)FACING, (Comparable)((Direction)sourceState.getValue((Property)FACING)));
    }

    @Override
    protected BlockState getEmptyState(BlockState sourceState, Block block) {
        return (BlockState)super.getEmptyState(sourceState, block).setValue((Property)FACING, (Comparable)((Direction)sourceState.getValue((Property)FACING)));
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.6875));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.1875, (double)0.5625));
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.375, (double)0.625, (double)0.3125, (double)0.625));
        return shape;
    }

    private static VoxelShape makeShapeWithCandle() {
        VoxelShape shape = StandingCandleStickBlock.makeShape();
        shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.25, (double)0.4375, (double)0.5625, (double)0.6875, (double)0.5625));
        return shape;
    }
}

