/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class CooldownButton
extends Button {
    private float progress = 1.0f;

    public CooldownButton(int x, int y, int width, int height, @NotNull Component title, @NotNull Button.OnPress pressedAction) {
        super(x, y, width, height, title, pressedAction, Button.DEFAULT_NARRATION);
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int width = (int)((1.0f - this.progress) * (float)this.getWidth());
        guiGraphics.blitSprite(SPRITES.get(true, this.isHoveredOrFocused() && this.progress == 0.0f), this.getX(), this.getY(), width, this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.getFGColor();
        this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void updateState(float progress) {
        this.active = progress == 0.0f;
        this.progress = progress;
    }
}

