/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.components.CooldownButton;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DBNOScreen
extends Screen {
    @Nullable
    private final Component causeOfDeath;
    private int enableButtonsTimer;
    private CooldownButton resurrectButton;
    private Button dieButton;

    public DBNOScreen(@Nullable Component textComponent) {
        super((Component)Component.translatable((String)"gui.vampirism.dbno.title"));
        this.causeOfDeath = textComponent;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style style;
        if (this.causeOfDeath != null && mouseY > 85.0 && mouseY < 94.0 && (style = this.deriveDeathMessageStyle((int)mouseX)) != null && style.getClickEvent() != null && style.getClickEvent().getAction() == ClickEvent.Action.OPEN_URL) {
            this.handleComponentClicked(style);
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.causeOfDeath != null) {
            graphics.drawCenteredString(this.font, this.causeOfDeath, this.width / 2, 85, 0xFFFFFF);
        }
        if (this.causeOfDeath != null && mouseY > 85 && mouseY < 94) {
            Style style = this.deriveDeathMessageStyle(mouseX);
            graphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.enableButtonsTimer;
        if (this.enableButtonsTimer == 20) {
            this.dieButton.active = true;
        }
        this.resurrectButton.updateState(Optional.ofNullable(this.minecraft.player).map(VampirePlayer::get).filter(v -> v.getDbnoDuration() > 0).map(v -> Float.valueOf((float)v.getDbnoTimer() / (float)v.getDbnoDuration())).orElse(Float.valueOf(0.0f)).floatValue());
    }

    protected void init() {
        this.enableButtonsTimer = 0;
        this.dieButton = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 100, this.height / 4 + 72, 200, 20, (Component)Component.translatable((String)"gui.vampirism.dbno.die"), p_213021_1_ -> {
            VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.GIVE_UP));
            this.minecraft.setScreen(null);
        }));
        this.dieButton.active = false;
        this.resurrectButton = (CooldownButton)this.addRenderableWidget((GuiEventListener)new CooldownButton(this.width / 2 - 100, this.height / 4 + 96, 200, 20, (Component)Component.translatable((String)"gui.vampirism.dbno.resurrect"), p_213020_1_ -> {
            if (this.minecraft.player != null) {
                VampirePlayer.get((Player)this.minecraft.player).tryResurrect();
            }
            VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.RESURRECT));
            this.minecraft.setScreen(null);
        }));
        this.resurrectButton.updateState(1.0f);
    }

    @Nullable
    private Style deriveDeathMessageStyle(int mouseX) {
        if (this.causeOfDeath == null) {
            return null;
        }
        int i = this.minecraft.font.width((FormattedText)this.causeOfDeath);
        int j = this.width / 2 - i / 2;
        int k = this.width / 2 + i / 2;
        return mouseX >= j && mouseX <= k ? this.minecraft.font.getSplitter().componentStyleAtWidth((FormattedText)this.causeOfDeath, mouseX - j) : null;
    }
}

