/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.network.ServerboundNameItemPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NameSwordScreen
extends Screen {
    private static final String[] sword_names = new String[]{"Felthorn", "Aetherius", "Agatha", "Alpha", "Amnesia", "Anduril", "Apocalypse", "Armageddon", "Arondite", "Ashrune", "Betrayal", "Betrayer", "Blackout", "Blazefury", "Blazeguard", "Blinkstrike", "Bloodquench", "Bloodweep", "Brutality", "Celeste", "Chaos", "Cometfell", "Convergence", "Darkheart", "Dawn", "Dawnbreaker", "Deathbringer", "Deathraze", "Decimation", "Desolation", "Destiny's Song", "Dirge", "Doomblade", "Doombringer", "Draughtbane", "Due Diligence", "Echo", "Eclipse", "Endbringer", "Epilogue", "Espada", "Extinction", "Faithkeeper", "Fate", "Fleshrender", "Florance", "Frenzy", "Fury", "Ghost Reaver", "Ghostwalker", "Gladius", "Glimmer", "Godslayer", "Grasscutter", "Gutrender", "Hatred's Bite", "Heartseeker", "Heartstriker", "Hell's Scream", "Hellfire", "Piece Maker", "Hellreaver", "Honor's Call", "Hope's End", "Infamy", "Interrogator", "Justifier", "Kinslayer", "Klinge", "Knightfall", "Lament", "Lazarus", "Lifedrinker", "Light's Bane", "Lightbane", "Lightbringer", "Lightning", "Limbo", "Loyalty", "Malice", "Mangler", "Massacre", "Mercy", "Misery", "Mournblade", "Narcoleptic", "Needle", "Nethersbane", "Night's Edge", "Night's Fall", "Nightbane", "Nightcrackle", "Nightfall", "Nirvana", "Oathbreaker", "Oathkeeper", "Oblivion", "Omega", "Orenmir", "Peacekeeper", "Persuasion", "Prick", "Purifier", "Rage", "Ragespike", "Ragnarok", "Reckoning", "Reign", "Remorse", "Requiem", "Retirement", "Rigormortis", "Savagery", "Scalpel", "Scar", "Seethe", "Severance", "Shadow Strike", "Shadowsteel", "Silence", "Silencer", "Silver Saber", "Silverlight", "Skullcrusher", "Slice of Life", "Soul Reaper", "Soulblade", "Soulrapier", "Spada", "Spike", "Spineripper", "Spiteblade", "Stalker", "Starshatterer", "Sting", "Stinger", "Storm", "Storm Breaker", "Stormbringer", "Stormcaller", "Story-Weaver", "Striker", "Sun Strike", "Suspension", "Swan Song", "The Ambassador", "The Black Blade", "The End", "The Facelifter", "The Light", "The Oculus", "The Stake", "The Untamed", "The Unyielding", "The Void", "Thorn", "Thunder", "Toothpick", "Tranquility", "Treachery", "Trinity", "Tyrhung", "Unending Tyranny", "Unholy Might", "Valkyrie", "Vanquisher", "Vengeance", "Venom", "Venomshank", "Warmonger", "Widow Maker", "Willbreaker", "Winterthorn", "Wit's End", "Witherbrand", "Wolf", "Worldbreaker", "Worldslayer"};
    @NotNull
    private final Component yes;
    @NotNull
    private final Component no;
    private final List<FormattedCharSequence> listLines = new ArrayList<FormattedCharSequence>();
    @NotNull
    private final Component text1;
    @NotNull
    private final Component text2;
    private final ItemStack sword;
    private EditBox nameField;

    public NameSwordScreen(ItemStack sword) {
        super((Component)Component.translatable((String)"gui.vampirism.name_sword.title"));
        this.yes = Component.translatable((String)"gui.yes");
        this.no = Component.translatable((String)"gui.no");
        this.text1 = Component.translatable((String)"gui.vampirism.name_sword.title");
        this.text2 = Component.translatable((String)"gui.vampirism.name_sword.text");
        this.sword = sword;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 155, this.height / 6 + 96, 150, 20, this.yes, context -> {
            if (!StringUtils.isBlank((CharSequence)this.nameField.getValue())) {
                this.sword.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.nameField.getValue()));
                VampirismMod.proxy.sendToServer(new ServerboundNameItemPacket(Optional.of(this.nameField.getValue())));
            }
            this.minecraft.setScreen(null);
            this.minecraft.setWindowActive(true);
        }));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 155 + 160, this.height / 6 + 96, 150, 20, this.no, context -> {
            VampirismMod.proxy.sendToServer(new ServerboundNameItemPacket(Optional.empty()));
            this.minecraft.setScreen(null);
            this.minecraft.setWindowActive(true);
        }));
        this.listLines.clear();
        this.listLines.addAll(this.font.split((FormattedText)this.text2, this.width - 50));
        this.nameField = new EditBox(this.font, this.width / 2 - 155 + 77, this.height / 6 + 70, 155, 20, (Component)Component.literal((String)"text_sword"));
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setBordered(true);
        this.nameField.setMaxLength(35);
        this.nameField.setValue(sword_names[new Random().nextInt(sword_names.length)]);
        this.addWidget((GuiEventListener)this.nameField);
        this.setInitialFocus((GuiEventListener)this.nameField);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.text1, this.width / 2, 70, 0xFFFFFF);
        int i = 90;
        for (FormattedCharSequence s : this.listLines) {
            graphics.drawString(this.font, s, (int)((float)this.width / 2.0f - (float)this.font.width(s) / 2.0f), i, 0xFFFFFF, false);
            Objects.requireNonNull(this.font);
            i += 9;
        }
        this.nameField.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void resize(@NotNull Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String text = this.nameField.getValue();
        super.resize(p_resize_1_, p_resize_2_, p_resize_3_);
        this.nameField.setValue(text);
    }
}

