/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.renderer.entity.layers.TaskMasterTypeLayer;
import de.teamlapen.vampirism.entity.hunter.HunterTaskMasterEntity;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HunterTaskMasterRenderer
extends MobRenderer<HunterTaskMasterEntity, VillagerModel<HunterTaskMasterEntity>> {
    private static final ResourceLocation texture = VResourceLocation.mc("textures/entity/villager/villager.png");
    private static final ResourceLocation overlay = VResourceLocation.mod("textures/entity/hunter_task_master_overlay.png");

    public HunterTaskMasterRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VillagerModel(context.bakeLayer(ModEntitiesRender.TASK_MASTER)), 0.5f);
        this.addLayer(new TaskMasterTypeLayer(this, overlay));
        this.addLayer(new HelmetLayer((RenderLayerParent<HunterTaskMasterEntity, VillagerModel<HunterTaskMasterEntity>>)this, context.getItemInHandRenderer()));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HunterTaskMasterEntity entity) {
        return texture;
    }

    protected void renderNameTag(@NotNull HunterTaskMasterEntity entityIn, @NotNull Component displayNameIn, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, float partialTicks) {
        double dist = this.entityRenderDispatcher.distanceToSqr((Entity)entityIn);
        if (dist <= 128.0) {
            super.renderNameTag((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        }
    }

    protected boolean shouldShowName(HunterTaskMasterEntity pEntity) {
        return Helper.isHunter((Entity)pEntity) && super.shouldShowName((Mob)pEntity);
    }

    private static class HelmetLayer
    extends RenderLayer<HunterTaskMasterEntity, VillagerModel<HunterTaskMasterEntity>> {
        private final ItemInHandRenderer pItemInHandRenderer;

        public HelmetLayer(RenderLayerParent<HunterTaskMasterEntity, VillagerModel<HunterTaskMasterEntity>> pRenderer, ItemInHandRenderer pItemInHandRenderer) {
            super(pRenderer);
            this.pItemInHandRenderer = pItemInHandRenderer;
        }

        public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, HunterTaskMasterEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            ItemStack itemstack = pLivingEntity.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemstack.isEmpty()) {
                pPoseStack.pushPose();
                ((VillagerModel)this.getParentModel()).getHead().translateAndRotate(pPoseStack);
                CustomHeadLayer.translateToHead((PoseStack)pPoseStack, (boolean)true);
                pPoseStack.translate(0.0f, -0.2f, 0.0f);
                pPoseStack.scale(1.1f, 1.1f, 1.1f);
                this.pItemInHandRenderer.renderItem((LivingEntity)pLivingEntity, itemstack, ItemDisplayContext.HEAD, false, pPoseStack, pBuffer, pPackedLight);
                pPoseStack.popPose();
            }
        }
    }
}

