/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SkillArgument
implements ArgumentType<ISkill<?>> {
    public static final DynamicCommandExceptionType SKILL_NOT_FOUND = new DynamicCommandExceptionType(particle -> Component.translatable((String)"command.vampirism.argument.skill.notfound", (Object[])new Object[]{particle}));
    private static final Collection<String> EXAMPLES = Arrays.asList("skill", "modid:skill");

    @NotNull
    public static SkillArgument skills() {
        return new SkillArgument();
    }

    public static ISkill<?> getSkill(@NotNull CommandContext<CommandSourceStack> context, String name) {
        return (ISkill)context.getArgument(name, ISkill.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource((Iterable)ModRegistries.SKILLS.keySet(), (SuggestionsBuilder)builder);
    }

    @NotNull
    public ISkill<?> parse(@NotNull StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        ISkill<?> skill = RegUtil.getSkill(id);
        if (skill == null) {
            throw SKILL_NOT_FOUND.create((Object)id);
        }
        return skill;
    }
}

