/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IMinionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionData;
import de.teamlapen.vampirism.api.entity.minion.IMinionEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MinionCommand
extends BasicCommand {
    private static final DynamicCommandExceptionType fail = new DynamicCommandExceptionType(msg -> Component.literal((String)("Failed: " + String.valueOf(msg))));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"minion").requires(context -> context.hasPermission(2))).then(MinionCommand.registerNew())).then(((LiteralArgumentBuilder)Commands.literal((String)"recall").executes(context -> MinionCommand.recall((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MinionCommand.recall((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"respawnAll").executes(context -> MinionCommand.respawn((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MinionCommand.respawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"purge").executes(context -> MinionCommand.purge((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MinionCommand.purge((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> registerNew() {
        LiteralArgumentBuilder spawnNew = Commands.literal((String)"spawnNew");
        Collection<IFactionRegistry.IMinionEntry<?, ?>> minions = VampirismAPI.factionRegistry().getMinions();
        for (IFactionRegistry.IMinionEntry<?, ?> minion : minions) {
            if (minion.type() == null) continue;
            RequiredArgumentBuilder currentCommand = null;
            List<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<?, ?>> iCommandEntries = minion.commandArguments();
            for (int i = iCommandEntries.size() - 1; i >= 0; --i) {
                IMinionBuilder.IMinionCommandBuilder.ICommandEntry<?, ?> iCommandEntry = iCommandEntries.get(i);
                int finalI = i;
                RequiredArgumentBuilder builder = (RequiredArgumentBuilder)Commands.argument((String)iCommandEntry.name(), iCommandEntry.type()).executes(context -> MinionCommand.spawnNewMinionExtra((CommandContext<CommandSourceStack>)context, (CommandSourceStack)context.getSource(), minion.faction(), minion.data(), minion.type(), iCommandEntries.subList(0, finalI + 1), iCommandEntries.subList(finalI + 1, iCommandEntries.size())));
                if (currentCommand != null) {
                    builder.then((ArgumentBuilder)currentCommand);
                }
                currentCommand = builder;
            }
            spawnNew.then(((LiteralArgumentBuilder)Commands.literal((String)minion.faction().getID().toString()).executes(context -> MinionCommand.spawnNewMinionExtra((CommandContext<CommandSourceStack>)context, (CommandSourceStack)context.getSource(), minion.faction(), minion.data(), minion.type(), List.of(), iCommandEntries))).then(currentCommand));
        }
        return spawnNew;
    }

    private static <T extends MinionData> int spawnNewMinionExtra(@NotNull CommandContext<CommandSourceStack> source, @NotNull CommandSourceStack ctx, IPlayableFaction<?> faction, @NotNull Supplier<T> data, Supplier<EntityType<? extends IMinionEntity>> type, Collection<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<T, ?>> contextProvider, Collection<IMinionBuilder.IMinionCommandBuilder.ICommandEntry<T, ?>> defaultProvider) throws CommandSyntaxException {
        MinionData t = (MinionData)data.get();
        for (IMinionBuilder.IMinionCommandBuilder.ICommandEntry<T, ?> tiCommandEntry : contextProvider) {
            tiCommandEntry.setter().accept(t, tiCommandEntry.getter().apply(source, tiCommandEntry.name()));
        }
        for (IMinionBuilder.IMinionCommandBuilder.ICommandEntry<T, ?> tiCommandEntry : defaultProvider) {
            tiCommandEntry.setter().accept(t, tiCommandEntry.defaultValue());
        }
        t.setHealth(t.getMaxHealth());
        return MinionCommand.spawnNewMinion(ctx, faction, t, type.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends IMinionData> int spawnNewMinion(@NotNull CommandSourceStack ctx, IPlayableFaction<?> faction, @NotNull T data, EntityType<? extends IMinionEntity> type) throws CommandSyntaxException {
        ServerPlayer p = ctx.getPlayerOrException();
        FactionPlayerHandler fph = MinionCommand.handler((Player)p);
        PlayerMinionController controller = MinionWorldData.getData(ctx.getServer()).getOrCreateController(fph);
        if (!controller.hasFreeMinionSlot()) throw fail.create((Object)"No free slot");
        if (fph.getCurrentFaction() != faction) throw fail.create((Object)"Wrong faction");
        int id = controller.createNewMinionSlot((MinionData)data, type);
        if (id < 0) {
            throw fail.create((Object)"Failed to get new minion slot");
        }
        controller.createMinionEntityAtPlayer(id, (Player)p);
        return 0;
    }

    private static FactionPlayerHandler handler(Player player) {
        FactionPlayerHandler handler = FactionPlayerHandler.get(player);
        if (handler.getMaxMinions() <= 0) {
            throw new IllegalArgumentException("Can't have minions");
        }
        return handler;
    }

    private static int recall(@NotNull CommandSourceStack ctx, ServerPlayer player) throws CommandSyntaxException {
        FactionPlayerHandler factionPlayerHandler = MinionCommand.handler((Player)player);
        PlayerMinionController controller = MinionWorldData.getData(ctx.getServer()).getOrCreateController(factionPlayerHandler);
        Collection<Integer> ids = controller.recallMinions(true);
        for (Integer id : ids) {
            controller.createMinionEntityAtPlayer(id, (Player)player);
        }
        return 0;
    }

    private static int respawn(@NotNull CommandSourceStack ctx, ServerPlayer player) throws CommandSyntaxException {
        FactionPlayerHandler fph = MinionCommand.handler((Player)player);
        PlayerMinionController controller = MinionWorldData.getData(ctx.getServer()).getOrCreateController(fph);
        Collection<Integer> ids = controller.getUnclaimedMinions();
        for (Integer id : ids) {
            controller.createMinionEntityAtPlayer(id, (Player)player);
        }
        return 0;
    }

    private static int purge(@NotNull CommandSourceStack ctx, ServerPlayer player) throws CommandSyntaxException {
        MinionWorldData.getData(ctx.getServer()).purgeController(player.getUUID());
        player.displayClientMessage((Component)Component.literal((String)"Reload world"), false);
        return 0;
    }
}

