/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.command.arguments.SkillArgument;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.util.RegUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_FACTION = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.vampirism.test.skill.noinfaction"));

    public static ArgumentBuilder<CommandSourceStack, ?> registerTest() {
        return SkillCommand.create(Commands.literal((String)"skill"));
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return SkillCommand.create(Commands.literal((String)"skills"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> create(@NotNull ArgumentBuilder<CommandSourceStack, ?> builder) {
        return builder.requires(context -> context.hasPermission(3)).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)SkillArgument.skills()).executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), false))).then(Commands.literal((String)"force").executes(context -> SkillCommand.skill((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), SkillArgument.getSkill((CommandContext<CommandSourceStack>)context, "type"), true)))).then(Commands.literal((String)"disableall").executes(context -> SkillCommand.disableall((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.literal((String)"enableall").executes(context -> SkillCommand.enableAll((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException())));
    }

    private static int disableall(@NotNull CommandSourceStack commandSource, @NotNull ServerPlayer asPlayer) throws CommandSyntaxException {
        IFactionPlayer<?> factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer((Player)asPlayer).orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        factionPlayer.getSkillHandler().resetSkills();
        commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.skill.all_locked"), false);
        return 0;
    }

    private static int enableAll(@NotNull CommandSourceStack commandSource, @NotNull ServerPlayer asPlayer) throws CommandSyntaxException {
        FactionPlayerHandler playerHandler = FactionPlayerHandler.get((Player)asPlayer);
        IFactionPlayer<?> factionPlayer = playerHandler.getCurrentFactionPlayer().orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        ISkillHandler<?> skillHandler = factionPlayer.getSkillHandler();
        for (ISkill<?> skill : RegUtil.values(ModRegistries.SKILLS)) {
            if (skill.getFaction().map(f -> f != factionPlayer.getFaction()).orElse(false).booleanValue()) continue;
            skillHandler.enableSkill(skill);
        }
        commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.skill.all_unlocked"), false);
        return 0;
    }

    private static int skill(@NotNull CommandSourceStack commandSource, @NotNull ServerPlayer asPlayer, @NotNull ISkill skill, boolean force) throws CommandSyntaxException {
        IFactionPlayer<?> factionPlayer = FactionPlayerHandler.getCurrentFactionPlayer((Player)asPlayer).orElseThrow(() -> ((SimpleCommandExceptionType)NO_FACTION).create());
        if (factionPlayer.getSkillHandler().isSkillEnabled(skill)) {
            factionPlayer.getSkillHandler().disableSkill(skill);
            commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.skill.disabled"), false);
            return 0;
        }
        ISkillHandler.Result result = factionPlayer.getSkillHandler().canSkillBeEnabled(skill);
        if (force) {
            result = ISkillHandler.Result.OK;
        }
        switch (result) {
            case OK: {
                factionPlayer.getSkillHandler().enableSkill(skill);
                commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.skill.enabled", (Object[])new Object[]{String.valueOf(RegUtil.id(skill)) + " (" + skill.getName().getString() + ")"}), false);
                break;
            }
            case ALREADY_ENABLED: {
                commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.skill.alreadyenabled", (Object[])new Object[]{skill.getName()}), false);
                break;
            }
            case PARENT_NOT_ENABLED: {
                ISkill<?>[] skills = factionPlayer.getSkillHandler().getParentSkills(skill);
                if (skills == null || skills.length == 0) {
                    return 0;
                }
                if (skills.length == 1) {
                    commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.parent", (Object[])new Object[]{RegUtil.id(skills[0])}));
                    break;
                }
                commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.parents", (Object[])new Object[]{RegUtil.id(skills[0]), RegUtil.id(skills[1])}));
                break;
            }
            case NO_POINTS: {
                commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.nopoints"));
                break;
            }
            case OTHER_NODE_SKILL: {
                commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.othernode"));
                break;
            }
            case NOT_FOUND: {
                commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.otherfaction"));
                break;
            }
            case LOCKED_BY_OTHER_NODE: {
                commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.locked"));
                break;
            }
            case LOCKED_BY_PLAYER_STATE: {
                commandSource.sendFailure((Component)Component.translatable((String)"command.vampirism.test.skill.locked_player_state"));
            }
        }
        return 0;
    }
}

