/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModSounds {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"vampirism");
    public static final DeferredHolder<SoundEvent, SoundEvent> ENTITY_VAMPIRE_SCREAM = ModSounds.create("entity.vampire_scream");
    public static final DeferredHolder<SoundEvent, SoundEvent> VAMPIRE_BITE = ModSounds.create("entity.vampire_bite");
    public static final DeferredHolder<SoundEvent, SoundEvent> AMBIENT_BLOOD_DRIPPING = ModSounds.create("ambient.blood_dripping");
    public static final DeferredHolder<SoundEvent, SoundEvent> COFFIN_LID = ModSounds.create("block.coffin_lid");
    public static final DeferredHolder<SoundEvent, SoundEvent> BAT_SWARM = ModSounds.create("entity.bat_swarm");
    public static final DeferredHolder<SoundEvent, SoundEvent> BOILING = ModSounds.create("block.boiling");
    public static final DeferredHolder<SoundEvent, SoundEvent> GRINDER = ModSounds.create("block.grinder");
    public static final DeferredHolder<SoundEvent, SoundEvent> TASK_COMPLETE = ModSounds.create("task_complete");
    public static final DeferredHolder<SoundEvent, SoundEvent> VAMPIRE_FEEDING = ModSounds.create("entity.vampire_feeding");
    public static final DeferredHolder<SoundEvent, SoundEvent> BLESSING_MUSIC = ModSounds.create("block.blessing_music");
    public static final DeferredHolder<SoundEvent, SoundEvent> BLOOD_PROJECTILE_HIT = ModSounds.create("fx.blood_projectile_hit");
    public static final DeferredHolder<SoundEvent, SoundEvent> WEAPON_TABLE_CRAFTING = ModSounds.create("block.weapon_table_crafting");
    public static final DeferredHolder<SoundEvent, SoundEvent> STAKE = ModSounds.create("fx.stake");
    public static final DeferredHolder<SoundEvent, SoundEvent> TELEPORT_AWAY = ModSounds.create("fx.teleport_away");
    public static final DeferredHolder<SoundEvent, SoundEvent> TELEPORT_HERE = ModSounds.create("fx.teleport_here");
    public static final DeferredHolder<SoundEvent, SoundEvent> FREEZE = ModSounds.create("fx.freeze");
    public static final DeferredHolder<SoundEvent, SoundEvent> POTION_TABLE_CRAFTING = ModSounds.create("block.potion_table_crafting");
    public static final DeferredHolder<SoundEvent, SoundEvent> MOTHER_DEATH = ModSounds.create("fx.mother_death");
    public static final DeferredHolder<SoundEvent, SoundEvent> MOTHER_AMBIENT = ModSounds.create("ambient.mother");
    public static final DeferredHolder<SoundEvent, SoundEvent> VAMPIRE_FOREST_AMBIENT = ModSounds.create("ambient.forest");
    public static final DeferredHolder<SoundEvent, SoundEvent> GHOST_AMBIENT = ModSounds.create("entity.ghost.ambient");
    public static final DeferredHolder<SoundEvent, SoundEvent> GHOST_DEATH = ModSounds.create("entity.ghost.death");
    public static final DeferredHolder<SoundEvent, SoundEvent> GHOST_HURT = ModSounds.create("entity.ghost.hurt");
    public static final DeferredHolder<SoundEvent, SoundEvent> REMAINS_DEFENDER_AMBIENT = ModSounds.create("entity.remains_defender.ambient");
    public static final DeferredHolder<SoundEvent, SoundEvent> REMAINS_DEFENDER_DEATH = ModSounds.create("entity.remains_defender.death");
    public static final DeferredHolder<SoundEvent, SoundEvent> REMAINS_DEFENDER_HURT = ModSounds.create("entity.remains_defender.hit");
    public static final DeferredHolder<SoundEvent, SoundEvent> REMAINS_DEATH = ModSounds.create("entity.remains.death");
    public static final DeferredHolder<SoundEvent, SoundEvent> REMAINS_HURT = ModSounds.create("entity.remains.hurt");
    private static final Map<ResourceKey<SoundEvent>, Music> music = new HashMap<ResourceKey<SoundEvent>, Music>();

    static void register(IEventBus bus) {
        SOUND_EVENTS.register(bus);
    }

    private static DeferredHolder<SoundEvent, SoundEvent> create(@NotNull String soundNameIn) {
        ResourceLocation resourcelocation = VResourceLocation.mod(soundNameIn);
        return SOUND_EVENTS.register(soundNameIn, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)resourcelocation));
    }

    public static Music getMusic(ResourceKey<SoundEvent> soundEvent) {
        return music.computeIfAbsent(soundEvent, sound -> BuiltInRegistries.SOUND_EVENT.getHolder(sound).map(event -> new Music((Holder)event, 0, 0, true)).orElse(Musics.GAME));
    }
}

