/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.items.component.OilContent;
import de.teamlapen.vampirism.recipes.AlchemyTableRecipe;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableRecipeBuilder
implements RecipeBuilder {
    @NotNull
    protected final ItemStack result;
    protected String group;
    protected Ingredient ingredient;
    @NotNull
    protected final IOil ingredientOil = (IOil)ModOils.EMPTY.get();
    protected Ingredient input;
    protected final List<ISkill<?>> skills = new LinkedList();
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    @NotNull
    public static AlchemyTableRecipeBuilder builder(@NotNull ItemStack stack) {
        return new AlchemyTableRecipeBuilder(stack);
    }

    @NotNull
    public static AlchemyTableRecipeBuilder builder(@NotNull Holder<IOil> oilStack) {
        return new AlchemyTableRecipeBuilder(OilContent.createItemStack((Item)ModItems.OIL_BOTTLE.get(), oilStack));
    }

    public AlchemyTableRecipeBuilder(@NotNull ItemStack result) {
        this.result = result;
    }

    @NotNull
    public AlchemyTableRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder ingredient(@NotNull Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder oilIngredient(@NotNull Holder<IOil> oil) {
        this.ingredient = DataComponentIngredient.of((boolean)false, ModDataComponents.OIL, (Object)new OilContent(oil), (ItemLike[])new ItemLike[]{(ItemLike)ModItems.OIL_BOTTLE.get()});
        return this;
    }

    public AlchemyTableRecipeBuilder plantOilIngredient() {
        return this.ingredient(DataComponentIngredient.of((boolean)false, ModDataComponents.OIL, (Object)new OilContent((Holder<IOil>)ModOils.PLANT), (ItemLike[])new ItemLike[]{(ItemLike)ModItems.OIL_BOTTLE.get()})).unlockedBy("has_bottles", (Criterion)AlchemyTableRecipeBuilder.has((ItemLike)ModItems.OIL_BOTTLE.get()));
    }

    public AlchemyTableRecipeBuilder bloodOilIngredient() {
        return this.ingredient(DataComponentIngredient.of((boolean)false, ModDataComponents.OIL, (Object)new OilContent((Holder<IOil>)ModOils.VAMPIRE_BLOOD), (ItemLike[])new ItemLike[]{(ItemLike)ModItems.OIL_BOTTLE.get()})).unlockedBy("has_bottles", (Criterion)AlchemyTableRecipeBuilder.has((ItemLike)ModItems.OIL_BOTTLE.get()));
    }

    @NotNull
    public AlchemyTableRecipeBuilder input(@NotNull Ingredient input) {
        this.input = input;
        return this;
    }

    @NotNull
    public AlchemyTableRecipeBuilder withSkills(ISkill<?> ... skills) {
        this.skills.addAll(Arrays.asList(skills));
        return this;
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation resourceLocation) {
        Advancement.Builder advancement = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)resourceLocation)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)resourceLocation)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        AlchemyTableRecipe recipe = new AlchemyTableRecipe(Objects.requireNonNullElse(this.group, ""), this.ingredient, this.input, this.result, this.skills);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, advancement.build(resourceLocation.withPrefix("recipes/alchemy_table/")));
    }

    @NotNull
    public AlchemyTableRecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result.getItem();
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike p_125978_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{p_125978_}));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> p_206407_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.item().of(p_206407_));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... p_299111_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger((ItemPredicate[])Arrays.stream(p_299111_).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... p_126012_) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(p_126012_)));
    }
}

