/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.datamaps;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.datamaps.IConverterEntry;
import de.teamlapen.vampirism.api.entity.convertible.Converter;
import de.teamlapen.vampirism.entity.converted.converter.DefaultConverter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;

public record ConverterEntry(Converter converter, Optional<ResourceLocation> overlay) implements IConverterEntry
{
    public static final Codec<IConverterEntry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Converter.CODEC.optionalFieldOf("handler", (Object)new DefaultConverter()).forGetter(IConverterEntry::converter), (App)ResourceLocation.CODEC.optionalFieldOf("overlay").forGetter(IConverterEntry::overlay)).apply((Applicative)inst, ConverterEntry::new));

    public ConverterEntry(Converter converter, ResourceLocation overlay) {
        this(converter, Optional.of(overlay));
    }

    public ConverterEntry(@Nullable ResourceLocation overlay) {
        this((Converter)new DefaultConverter(), Optional.ofNullable(overlay));
    }

    public ConverterEntry(Converter converter) {
        this(converter, Optional.empty());
    }

    public record ConvertingAttributeModifier(Map<Holder<Attribute>, Pair<FloatProvider, Double>> attributeModifier) {
        public static ConvertingAttributeModifier DEFAULT = new ConvertingAttributeModifier(Map.of(Attributes.ATTACK_DAMAGE, Pair.of((Object)ConstantFloat.of((float)1.3f), (Object)1.0), Attributes.KNOCKBACK_RESISTANCE, Pair.of((Object)ConstantFloat.of((float)1.3f), (Object)0.0), Attributes.MAX_HEALTH, Pair.of((Object)ConstantFloat.of((float)1.5f), (Object)1.0), Attributes.MOVEMENT_SPEED, Pair.of((Object)ConstantFloat.of((float)1.2f), (Object)1.0)));
        private static final Codec<Pair<Holder<Attribute>, Pair<FloatProvider, Double>>> CODEC_PAIR = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(Pair::getFirst), (App)FloatProvider.CODEC.fieldOf("modifier").forGetter(s -> (FloatProvider)((Pair)s.getSecond()).getFirst()), (App)Codec.DOUBLE.optionalFieldOf("fallback_base", (Object)1.0).forGetter(s -> (Double)((Pair)s.getSecond()).getSecond())).apply((Applicative)inst, (attribute, floatProvider, aDouble) -> Pair.of((Object)attribute, (Object)Pair.of((Object)floatProvider, (Object)aDouble))));
        public static final Codec<ConvertingAttributeModifier> CODEC = CODEC_PAIR.listOf().xmap(ConvertingAttributeModifier::new, x -> x.attributeModifier.entrySet().stream().map(s -> Pair.of((Object)((Holder)s.getKey()), (Object)Pair.of((Object)((FloatProvider)((Pair)s.getValue()).getFirst()), (Object)((Double)((Pair)s.getValue()).getSecond())))).collect(Collectors.toList()));

        public ConvertingAttributeModifier(List<Pair<Holder<Attribute>, Pair<FloatProvider, Double>>> values) {
            this(values.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> b)));
        }

        public Pair<FloatProvider, Double> modifier(Attribute attribute) {
            return this.attributeModifier.get(attribute);
        }
    }
}

