/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.IEntityFollower;
import de.teamlapen.vampirism.entity.IRemainsEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import de.teamlapen.vampirism.entity.ai.goals.DefendLeaderGoal;
import de.teamlapen.vampirism.entity.ai.goals.FindLeaderGoal;
import de.teamlapen.vampirism.entity.ai.goals.NearestTargetGoalModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GhostEntity
extends VampirismEntity
implements IRemainsEntity,
IEntityFollower {
    private static final ResourceLocation SPEED_MODIFIER = VResourceLocation.mod("not_in_block");
    private IEntityLeader leader;

    public GhostEntity(@NotNull EntityType<? extends VampirismEntity> type, @NotNull Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 15.0).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.3).add(Attributes.ENTITY_INTERACTION_RANGE, 1.0);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        GhostPathNavigation navigation = new GhostPathNavigation((Mob)this, pLevel);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return pSource.is(DamageTypeTags.IS_PROJECTILE) || pSource.is(ModTags.DamageTypes.MOTHER_RESISTANT_TO) && super.isInvulnerableTo(pSource);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GhostMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(3, new FindLeaderGoal<GhostEntity, LivingEntity>(this, arg_0 -> GhostEntity.lambda$registerGoals$0(VulnerableRemainsDummyEntity.class, arg_0)));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.9f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        NearestAttackableTargetGoal goal = new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true, false, true, true, null));
        ((NearestTargetGoalModifier)goal).ignoreLineOfSight();
        this.targetSelector.addGoal(3, (Goal)goal);
        NearestAttackableTargetGoal<PathfinderMob> goal2 = new NearestAttackableTargetGoal<PathfinderMob>(this, (Mob)this, PathfinderMob.class, 5, false, false, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, false, true, false, true, null)){

            protected double getFollowDistance() {
                return super.getFollowDistance() / 2.0;
            }
        };
        ((NearestTargetGoalModifier)goal2).ignoreLineOfSight();
        this.targetSelector.addGoal(4, (Goal)goal2);
        this.targetSelector.addGoal(8, new DefendLeaderGoal<GhostEntity>(this));
    }

    @Override
    public void tick() {
        this.setNoGravity(true);
        this.noPhysics = true;
        this.checkInsideBlocks();
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
    }

    protected void onInsideBlock(BlockState pState) {
        if (pState.isAir()) {
            AttributeInstance attribute = this.getAttribute(Attributes.FLYING_SPEED);
            if (attribute != null && attribute.getModifier(SPEED_MODIFIER) == null) {
                attribute.addTransientModifier(new AttributeModifier(SPEED_MODIFIER, 0.2, AttributeModifier.Operation.ADD_VALUE));
            }
        } else {
            AttributeInstance attribute = this.getAttribute(Attributes.FLYING_SPEED);
            if (attribute != null) {
                attribute.removeModifier(SPEED_MODIFIER);
            }
        }
    }

    @Override
    public boolean isFollowing() {
        return this.leader != null;
    }

    @Override
    public <T extends LivingEntity> T getLeader() {
        return (T)((LivingEntity)this.leader);
    }

    @Override
    public <T extends LivingEntity> void setLeader(T leader) {
        this.leader = (IEntityLeader)leader;
    }

    public float getPathfindingMalus(PathType type) {
        return 0.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.GHOST_AMBIENT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.GHOST_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.GHOST_HURT.get();
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    private static /* synthetic */ boolean lambda$registerGoals$0(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }

    static class GhostPathNavigation
    extends FlyingPathNavigation {
        public GhostPathNavigation(Mob pMob, Level pLevel) {
            super(pMob, pLevel);
        }

        protected boolean canMoveDirectly(@NotNull Vec3 pPosVec31, @NotNull Vec3 pPosVec32) {
            return true;
        }
    }

    class GhostMeleeAttackGoal
    extends MeleeAttackGoal {
        public GhostMeleeAttackGoal(GhostEntity this$0, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)this$0, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }
    }
}

