/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.blockentity.MotherBlockEntity;
import de.teamlapen.vampirism.blockentity.VulnerableRemainsBlockEntity;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.IRemainsEntity;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemainsDefenderEntity
extends Mob
implements IRemainsEntity {
    protected static final EntityDataAccessor<Direction> DATA_ATTACH_FACE_ID = SynchedEntityData.defineId(RemainsDefenderEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Integer> DATA_LIGHT_TICKS_REMAINING = SynchedEntityData.defineId(RemainsDefenderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 15.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ARMOR_TOUGHNESS, 6.0);
    }

    public RemainsDefenderEntity(EntityType<RemainsDefenderEntity> type, Level pLevel) {
        super(type, pLevel);
        this.xpReward = 5;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f, 0.5f, false));
        this.goalSelector.addGoal(2, (Goal)new RemainsDefenderAttackGoal());
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new RemainsDefenderAttackTargetGoal(this));
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 512L == 32L && this.getVehicle() == null && !this.level().getBlockState(this.blockPosition().relative(this.getAttachFace())).is(ModTags.Blocks.ACTIVE_REMAINS)) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void aiStep() {
        super.aiStep();
        int i = this.getLightTicksRemaining();
        if (i > 0) {
            this.setLightTicksRemaining(i - 1);
        }
    }

    public boolean isInvulnerableTo(@NotNull DamageSource pSource) {
        return pSource.is(ModTags.DamageTypes.MOTHER_RESISTANT_TO) || pSource.is(DamageTypes.IN_WALL) || pSource.is(DamageTypes.DROWN) || super.isInvulnerableTo(pSource);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.REMAINS_DEFENDER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.REMAINS_DEFENDER_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.REMAINS_DEFENDER_HURT.get();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ATTACH_FACE_ID, (Object)Direction.DOWN);
        builder.define(DATA_LIGHT_TICKS_REMAINING, (Object)0);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setAttachFace(Direction.from3DDataValue((int)pCompound.getByte("AttachFace")));
        this.setLightTicksRemaining(pCompound.getInt("LightTicks"));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putByte("AttachFace", (byte)this.getAttachFace().get3DDataValue());
        pCompound.putInt("LightTicks", this.getLightTicksRemaining());
    }

    protected boolean canRide(@NotNull Entity pVehicle) {
        return pVehicle instanceof VulnerableRemainsDummyEntity;
    }

    public void rideTick() {
        this.tick();
    }

    public void move(@NotNull MoverType pType, @NotNull Vec3 pPos) {
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        if (super.hurt(pSource, pAmount)) {
            this.getDummy().ifPresent(vehicle -> vehicle.childrenIsHurt(pSource, this.dead, this.getAttachFace()));
            return true;
        }
        return false;
    }

    protected void actuallyHurt(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        super.actuallyHurt(pDamageSource, pDamageAmount);
        this.invulnerableTime *= 2;
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return Vec3.ZERO;
    }

    public void setDeltaMovement(@NotNull Vec3 pDeltaMovement) {
    }

    public void setAttachFace(Direction face) {
        this.entityData.set(DATA_ATTACH_FACE_ID, (Object)face);
    }

    public Direction getAttachFace() {
        return (Direction)this.entityData.get(DATA_ATTACH_FACE_ID);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> pKey) {
        if (DATA_ATTACH_FACE_ID.equals(pKey)) {
            this.setBoundingBox(this.makeBoundingBox());
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    protected float getStandingEyeHeight(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return switch (this.getAttachFace()) {
            case Direction.UP -> 0.8f;
            case Direction.DOWN -> 0.2f;
            default -> 0.5f;
        };
    }

    public void push(@NotNull Entity pEntity) {
    }

    public boolean startRiding(Entity pEntity, boolean pForce) {
        if (super.startRiding(pEntity, pForce)) {
            this.reapplyPosition();
            return true;
        }
        return false;
    }

    @NotNull
    protected AABB makeBoundingBox() {
        Direction attachFace = this.getAttachFace().getOpposite();
        AABB box = new AABB(BlockPos.ZERO);
        return (switch (attachFace.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> box.contract(0.0, 0.25, 0.25).contract(0.0, -0.25, -0.25);
            case Direction.Axis.Y -> box.contract(0.25, 0.0, 0.25).contract(-0.25, 0.0, -0.25);
            case Direction.Axis.Z -> box.contract(0.25, 0.25, 0.0).contract(-0.25, -0.25, 0.0);
        }).contract((double)attachFace.getStepX() * 0.75, (double)attachFace.getStepY() * 0.75, (double)attachFace.getStepZ() * 0.75).move(this.blockPosition());
    }

    public Optional<VulnerableRemainsDummyEntity> getDummy() {
        return Optional.ofNullable(this.getVehicle()).filter(VulnerableRemainsDummyEntity.class::isInstance).map(VulnerableRemainsDummyEntity.class::cast);
    }

    private void setLightTicksRemaining(int ticks) {
        this.entityData.set(DATA_LIGHT_TICKS_REMAINING, (Object)ticks);
    }

    public int getLightTicksRemaining() {
        return (Integer)this.entityData.get(DATA_LIGHT_TICKS_REMAINING);
    }

    protected void reapplyPosition() {
        if (this.getVehicle() != null) {
            Direction attachFace = this.getAttachFace();
            this.setPos(Vec3.atBottomCenterOf((Vec3i)this.getVehicle().blockPosition().above()).subtract((double)attachFace.getStepX(), (double)attachFace.getStepY(), (double)attachFace.getStepZ()));
        } else {
            super.reapplyPosition();
        }
    }

    class RemainsDefenderAttackGoal
    extends Goal {
        private int attackTime;

        public RemainsDefenderAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity livingentity = RemainsDefenderEntity.this.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                return RemainsDefenderEntity.this.level().getDifficulty() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void start() {
            this.attackTime = 40;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (RemainsDefenderEntity.this.level().getDifficulty() != Difficulty.PEACEFUL) {
                --this.attackTime;
                LivingEntity livingentity = RemainsDefenderEntity.this.getTarget();
                if (livingentity != null) {
                    RemainsDefenderEntity.this.getLookControl().setLookAt((Entity)livingentity, 180.0f, 180.0f);
                    double d0 = RemainsDefenderEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 400.0) {
                        if (this.attackTime <= 0) {
                            this.attackTime = 20 + RemainsDefenderEntity.this.random.nextInt(10) * 20 / 2;
                            Vec3 position = RemainsDefenderEntity.this.position();
                            Vec3 direction = RemainsDefenderEntity.this.getViewVector(1.0f);
                            DarkBloodProjectileEntity projectile = new DarkBloodProjectileEntity(RemainsDefenderEntity.this.level(), position.x(), position.y(), position.z(), direction);
                            projectile.setOwner((Entity)RemainsDefenderEntity.this);
                            projectile.setDamage((float)RemainsDefenderEntity.this.getAttributeValue(Attributes.ATTACK_DAMAGE), 0.0f);
                            projectile.excludeShooter();
                            RemainsDefenderEntity.this.level().addFreshEntity((Entity)projectile);
                            RemainsDefenderEntity.this.setLightTicksRemaining(40);
                        }
                    } else {
                        RemainsDefenderEntity.this.setTarget(null);
                    }
                    super.tick();
                }
            }
        }
    }

    static class RemainsDefenderAttackTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public RemainsDefenderAttackTargetGoal(RemainsDefenderEntity entity) {
            super((Mob)entity, LivingEntity.class, 10, true, false, target -> {
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    if (entity.getDummy().flatMap(VulnerableRemainsDummyEntity::getTile).flatMap(VulnerableRemainsBlockEntity::getMother).map(MotherBlockEntity::involvedPlayers).stream().anyMatch(s -> s.contains(player))) {
                        return true;
                    }
                }
                return !(target instanceof IRemainsEntity) && !Helper.isVampire((Entity)target);
            });
        }
    }
}

