/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AttackRangedDarkBloodGoal
extends Goal {
    protected final VampireBaronEntity entity;
    private final int attackCooldown;
    private final int maxAttackDistance;
    private final float directDamage;
    private final float indirectDamage;
    private int attackTime;
    private int seeTime;

    public AttackRangedDarkBloodGoal(VampireBaronEntity entity, int cooldown, int maxDistance, float damage, float indirectDamage) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.attackCooldown = cooldown;
        this.maxAttackDistance = maxDistance;
        this.directDamage = damage;
        this.indirectDamage = indirectDamage;
    }

    public boolean canUse() {
        return this.entity.getTarget() != null;
    }

    public void stop() {
        this.seeTime = 0;
        this.attackTime = 0;
    }

    public void tick() {
        if (this.attackTime > 0) {
            --this.attackTime;
        } else {
            LivingEntity target = this.entity.getTarget();
            if (target != null) {
                boolean couldSee;
                double d0 = this.entity.distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ());
                boolean canSee = this.entity.getSensing().hasLineOfSight((Entity)target);
                boolean bl = couldSee = this.seeTime > 0;
                if (canSee != couldSee) {
                    this.seeTime = 0;
                }
                if (canSee) {
                    ++this.seeTime;
                    this.entity.lookAt((Entity)target, 19.0f, 10.0f);
                    this.entity.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition(1.0f));
                } else {
                    --this.seeTime;
                }
                if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                    this.attack(target);
                    this.attackTime = this.attackCooldown;
                    this.entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20));
                } else {
                    this.entity.getNavigation().moveTo((Entity)target, 1.0);
                }
            }
        }
    }

    protected void attack(@NotNull LivingEntity target) {
        Vec3 vec3d = target.position().add(0.0, (double)(target.getBbHeight() * 0.6f), 0.0).subtract(this.entity.getEyePosition(1.0f)).normalize();
        DarkBloodProjectileEntity projectile = new DarkBloodProjectileEntity(this.entity.getCommandSenderWorld(), this.entity.getX() + vec3d.x * (double)0.3f, this.entity.getY() + (double)(this.entity.getEyeHeight() * 0.9f), this.entity.getZ() + vec3d.z * (double)0.3f, vec3d);
        projectile.setOwner((Entity)this.entity);
        projectile.setDamage(this.directDamage, this.indirectDamage);
        if (this.entity.distanceToSqr((Entity)target) > 64.0) {
            projectile.setMotionFactor(0.95f);
        } else {
            projectile.setMotionFactor(0.75f);
        }
        projectile.setInitialNoClip();
        projectile.excludeShooter();
        this.entity.getCommandSenderWorld().addFreshEntity((Entity)projectile);
    }
}

