/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class MoveToBiteableVampireGoal<T extends Mob>
extends Goal {
    private final T vampire;
    private final double movementSpeed;
    @Nullable
    private PathfinderMob target;
    private int timeout;

    public MoveToBiteableVampireGoal(T vampire, double movementSpeed) {
        this.vampire = vampire;
        this.movementSpeed = movementSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return !this.vampire.getNavigation().isDone() && this.target.isAlive();
    }

    public boolean canUse() {
        if (this.timeout > 0) {
            --this.timeout;
            return false;
        }
        if (!((IVampire)this.vampire).wantsBlood()) {
            return false;
        }
        List list = this.vampire.getCommandSenderWorld().getEntitiesOfClass(PathfinderMob.class, this.vampire.getBoundingBox().inflate(10.0, 3.0, 10.0), EntitySelector.NO_SPECTATORS.and(entity -> entity != this.vampire && entity.isAlive()));
        for (PathfinderMob o : list) {
            if (!ExtendedCreature.getSafe((Entity)o).map(creature -> creature.canBeBitten((IVampire)this.vampire) && !creature.getEntity().hasCustomName() && !creature.hasPoisonousBlood()).orElse(false).booleanValue()) continue;
            this.target = o;
            return true;
        }
        this.target = null;
        return false;
    }

    public void start() {
        this.vampire.getNavigation().moveTo((Entity)this.target, 1.0);
    }

    public void stop() {
        this.target = null;
        this.timeout = this.vampire.getRandom().nextInt(5) == 0 ? 80 : 3;
    }
}

