/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.LevelAccessor;

public class RestrictSunVampireGoal<T extends PathfinderMob>
extends Goal {
    private final T vampire;
    private boolean cache = false;

    public RestrictSunVampireGoal(T creature) {
        this.vampire = creature;
    }

    public boolean canUse() {
        if (((PathfinderMob)this.vampire).tickCount % 10 == 3) {
            this.cache = VampirismAPI.sundamageRegistry().hasSunDamage((LevelAccessor)this.vampire.level(), this.vampire.blockPosition()) && !Helper.isEntityInArtificalVampireFogArea(this.vampire);
        }
        return this.cache && this.vampire.getCommandSenderWorld().isDay() && !((IVampire)this.vampire).isIgnoringSundamage();
    }

    public void start() {
        ((GroundPathNavigation)this.vampire.getNavigation()).setAvoidSun(true);
    }

    public void stop() {
        ((GroundPathNavigation)this.vampire.getNavigation()).setAvoidSun(false);
    }
}

