/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.ConvertedCreature;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.ai.goals.AttackMeleeNoSunGoal;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CurableConvertedCreature<T extends PathfinderMob, Z extends PathfinderMob>
extends ConvertedCreature<T>,
ICurableConvertedCreature<T> {
    @Override
    public Data<T> data();

    default public boolean hurtC(DamageSource damageSource, float amount) {
        PathfinderMob entity = (PathfinderMob)this;
        if (((Data)this.data()).vulnerableToFire) {
            if (damageSource.is(DamageTypes.IN_FIRE)) {
                return DamageHandler.hurtModded((Entity)entity, ModDamageSources::vampireInFire, this.calculateFireDamage(amount));
            }
            if (damageSource.is(DamageTypes.ON_FIRE)) {
                return DamageHandler.hurtModded((Entity)entity, ModDamageSources::vampireOnFire, this.calculateFireDamage(amount));
            }
        }
        return this.hurtSuper(damageSource, amount);
    }

    default public InteractionResult mobInteractC(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == Items.GOLDEN_APPLE) {
            return this.interactWithCureItem(player, stack, (PathfinderMob)this);
        }
        return this.mobInteractSuper(player, hand);
    }

    @Override
    default public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
         @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        ((PathfinderMob)this).addEffect(new MobEffectInstance(MobEffects.REGENERATION, event.getAmount() * 20));
    }

    @NotNull
    default public Component getNameC(@NotNull Supplier<Component> baseName) {
        if (((Data)this.data()).name == null) {
            ((Data)this.data()).name = Component.translatable((String)"entity.vampirism.vampire").append(" ").append(baseName.get());
        }
        return ((Data)this.data()).name;
    }

    default public void handleEntityEventC(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            this.handleEntityEventSuper(id);
        }
    }

    @Override
    default public boolean doesResistGarlic(@NotNull EnumStrength strength) {
        return !strength.isStrongerThan(EnumStrength.NONE);
    }

    @Override
    @NotNull
    default public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            ((Data)this.data()).garlicCache = Helper.getGarlicStrength((Entity)((PathfinderMob)this), iWorld);
        }
        return ((Data)this.data()).garlicCache;
    }

    @Override
    default public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return ((Data)this.data()).sundamageCache;
        }
        ((Data)this.data()).sundamageCache = Helper.gettingSundamge((LivingEntity)((PathfinderMob)this), iWorld, ((PathfinderMob)this).level().getProfiler());
        return ((Data)this.data()).sundamageCache;
    }

    @Override
    default public boolean isIgnoringSundamage() {
        return ((PathfinderMob)this).hasEffect(ModEffects.SUNSCREEN);
    }

    default public void aiStepC(@NotNull EntityType<T> originalType) {
        PathfinderMob entity = (PathfinderMob)this;
        if (!entity.level().isClientSide && entity.isAlive() && this.isConverting(entity)) {
            --((Data)this.data()).conversionTime;
            if (((Data)this.data()).conversionTime <= 0 && EventHooks.canLivingConvert((LivingEntity)entity, originalType, timer -> {
                ((Data)this.data()).conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)entity.level(), entity, originalType);
            }
        }
        if (entity.tickCount % 40 == 1) {
            this.isGettingGarlicDamage((LevelAccessor)entity.level(), true);
        }
        if (entity.tickCount % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)entity.level(), true);
        }
        if (!entity.level().isClientSide) {
            double dmg;
            if (this.isGettingSundamage((LevelAccessor)entity.level()) && entity.tickCount % 40 == 11 && (dmg = entity.getAttribute(ModAttributes.SUNDAMAGE).getValue()) > 0.0) {
                DamageHandler.hurtModded((Entity)entity, ModDamageSources::sunDamage, (float)dmg);
            }
            if (this.isGettingGarlicDamage((LevelAccessor)entity.level()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)entity.level()), entity.tickCount);
            }
            if (entity.isAlive() && entity.isInWater()) {
                entity.setAirSupply(300);
                if (entity.tickCount % 16 == 4) {
                    entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0));
                }
            }
        }
    }

    default public void dieC(@NotNull DamageSource cause) {
        if (cause.getDirectEntity() instanceof CrossbowArrowEntity && Helper.isHunter(cause.getEntity())) {
            ((Data)this.data()).dropSoul = true;
        } else if (cause.getDirectEntity() instanceof Player && Helper.isHunter(cause.getDirectEntity())) {
            ItemStack weapon = ((Player)cause.getDirectEntity()).getMainHandItem();
            if (!weapon.isEmpty() && weapon.getItem() instanceof IVampireFinisher) {
                ((Data)this.data()).dropSoul = true;
            }
        } else {
            ((Data)this.data()).dropSoul = false;
        }
    }

    @Override
    default public void readAdditionalSaveDataC(@NotNull CompoundTag compound) {
        ConvertedCreature.super.readAdditionalSaveDataC(compound);
        if (compound.contains("ConversionTime", 99) && compound.getInt("ConversionTime") > -1) {
            this.startConverting(compound.hasUUID("ConversionPlayer") ? compound.getUUID("ConversionPlayer") : null, compound.getInt("ConversionTime"), (PathfinderMob)this);
        }
        if (compound.contains("source_entity", 8)) {
            this.getSourceEntityDataParamOpt().ifPresent(s -> this.getRepresentingEntity().getEntityData().set(s, (Object)compound.getString("source_entity")));
        }
    }

    @Override
    default public void addAdditionalSaveDataC(@NotNull CompoundTag compound) {
        ConvertedCreature.super.addAdditionalSaveDataC(compound);
        compound.putInt("ConversionTime", this.isConverting((PathfinderMob)this) ? ((Data)this.data()).conversionTime : -1);
        if (((Data)this.data()).conversationStarter != null) {
            compound.putUUID("ConversionPlayer", ((Data)this.data()).conversationStarter);
        }
        if (this.getSourceEntityId() != null) {
            compound.putString("source_entity", this.getSourceEntityId());
        }
    }

    @Override
    default public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @NotNull PathfinderMob entity) {
        ICurableConvertedCreature.super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        ((Data)this.data()).conversationStarter = conversionStarterIn;
        ((Data)this.data()).conversionTime = conversionTimeIn;
    }

    @Override
    default public boolean useBlood(int amt, boolean allowPartial) {
        ((PathfinderMob)this).addEffect(new MobEffectInstance(MobEffects.WEAKNESS, amt * 20));
        return true;
    }

    @Override
    default public boolean wantsBlood() {
        return false;
    }

    default public float calculateFireDamage(float amount) {
        return amount;
    }

    default public void tickDeathC() {
        PathfinderMob entity = (PathfinderMob)this;
        if (entity.deathTime == 19 && !entity.level().isClientSide && ((Data)this.data()).dropSoul && entity.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            entity.level().addFreshEntity((Entity)new SoulOrbEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
    }

    default public void registerGoalsC() {
        PathfinderMob entity = (PathfinderMob)this;
        entity.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(entity, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, VReference.HUNTER_FACTION)));
        entity.goalSelector.addGoal(4, (Goal)new RestrictSunGoal(entity));
        entity.goalSelector.addGoal(5, (Goal)new AttackMeleeNoSunGoal(entity, 0.9, false));
        entity.goalSelector.addGoal(11, (Goal)new RandomStrollGoal(entity, 0.7));
        entity.goalSelector.addGoal(13, (Goal)new LookAtPlayerGoal((Mob)entity, Player.class, 6.0f));
        entity.goalSelector.addGoal(15, (Goal)new RandomLookAroundGoal((Mob)entity));
        entity.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal(entity, new Class[0]));
        entity.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, false, null)));
        entity.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)entity, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, false, false, false, null)));
    }

    @Override
    @NotNull
    default public LivingEntity getRepresentingEntity() {
        return (PathfinderMob)this;
    }

    public void handleEntityEventSuper(byte var1);

    public InteractionResult mobInteractSuper(@NotNull Player var1, @NotNull InteractionHand var2);

    public boolean hurtSuper(DamageSource var1, float var2);

    public static <T extends PathfinderMob, Z extends PathfinderMob> void createFrom() {
    }

    public static class Data<T>
    extends IConvertedCreature.Data<T> {
        public boolean vulnerableToFire = true;
        @NotNull
        public EnumStrength garlicCache = EnumStrength.NONE;
        public boolean sundamageCache;
        public boolean dropSoul = false;
        @Nullable
        public Component name;
        public int conversionTime;
        @Nullable
        public UUID conversationStarter;
    }
}

