/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillage;
import de.teamlapen.vampirism.entity.factions.FactionRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.NotNull;

public class Faction<T extends IFactionEntity>
implements IFaction<T> {
    private static int nextId = 0;
    protected final ResourceLocation id;
    private final Class<T> entityInterface;
    private final int color;
    private final boolean hostileTowardsNeutral;
    private final int integerId;
    @NotNull
    private final IFactionVillage villageFactionData;
    @NotNull
    private final Component name;
    @NotNull
    private final Component namePlural;
    @NotNull
    private final TextColor chatColor;
    private final Map<ResourceKey<? extends Registry<?>>, TagKey<?>> factionTags;

    Faction(@NotNull FactionRegistry.FactionBuilder<T> builder) {
        this.id = builder.id;
        this.entityInterface = builder.entityInterface;
        this.color = builder.color;
        this.hostileTowardsNeutral = builder.hostileTowardsNeutral;
        this.villageFactionData = builder.villageFactionData.build();
        this.chatColor = builder.chatColor == null ? TextColor.fromRgb((int)this.color) : builder.chatColor;
        this.name = builder.name == null ? Component.literal((String)this.id.toString()) : Component.translatable((String)builder.name);
        this.namePlural = builder.namePlural == null ? this.name : Component.translatable((String)builder.namePlural);
        this.factionTags = Collections.unmodifiableMap(builder.factionTags);
        this.integerId = nextId++;
    }

    public boolean equals(Object obj) {
        return obj instanceof Faction && this.id == ((Faction)obj).id;
    }

    @Override
    @NotNull
    public TextColor getChatColor() {
        return this.chatColor;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public Class<T> getFactionEntityInterface() {
        return this.entityInterface;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Component getNamePlural() {
        return this.namePlural;
    }

    @Override
    @NotNull
    public IFactionVillage getVillageData() {
        return this.villageFactionData;
    }

    public int hashCode() {
        return this.integerId;
    }

    @Override
    public boolean isEntityOfFaction(PathfinderMob creature) {
        return this.entityInterface.isInstance(creature);
    }

    @Override
    public boolean isHostileTowardsNeutral() {
        return this.hostileTowardsNeutral;
    }

    @Override
    public <Z> Optional<TagKey<Z>> getTag(ResourceKey<? extends Registry<Z>> registryKey) {
        return Optional.ofNullable(this.factionTags.get(registryKey));
    }

    public String toString() {
        return "Faction{id='" + this.integerId + "', hash=" + this.integerId + "}";
    }
}

