/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class VampireMinionEntity
extends MinionEntity<VampireMinionData>
implements IVampire {
    private boolean sundamageCache;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return BasicVampireEntity.getAttributeBuilder();
    }

    public VampireMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true, true, true, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Zombie) && !(e instanceof Skeleton) && !(e instanceof Creeper)));
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
         @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.heal((float)event.getAmount() / 3.0f);
    }

    @Override
    @NotNull
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{(IMinionTask)MinionTasks.FOLLOW_LORD.get(), (IMinionTask)MinionTasks.STAY.get(), (IMinionTask)MinionTasks.DEFEND_AREA.get(), (IMinionTask)MinionTasks.COLLECT_BLOOD.get(), (IMinionTask)MinionTasks.PROTECT_LORD.get()});
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public int getVampireType() {
        return this.getMinionData().map(d -> d.type).map(t -> Math.max(0, t)).orElse(0);
    }

    public boolean hasMinionSpecificSkin() {
        return this.getMinionData().map(d -> d.minionSkin).orElse(false);
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public void aiStep() {
        if (this.tickCount % 40 == 3) {
            this.isGettingGarlicDamage((LevelAccessor)this.level(), true);
        }
        if (this.tickCount % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.level(), true);
        }
        if (!this.level().isClientSide) {
            double dmg;
            if (this.isGettingSundamage((LevelAccessor)this.level()) && this.tickCount % 40 == 11 && (dmg = this.getAttribute((Holder)ModAttributes.SUNDAMAGE).getValue()) > 0.0) {
                DamageHandler.hurtModded((Entity)this, ModDamageSources::sunDamage, (float)dmg);
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.level()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.level()), this.tickCount);
            }
        }
        if (!this.level().isClientSide && this.isAlive() && this.isInWater()) {
            this.setAirSupply(300);
            if (this.tickCount % 16 == 4) {
                this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0));
            }
        }
        super.aiStep();
    }

    @Override
    @NotNull
    public ItemStack eat(@NotNull Level world, @NotNull ItemStack stack, @NotNull FoodProperties properties) {
        return stack;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.level().getProfiler());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.hasEffect((Holder)ModEffects.SUNSCREEN);
    }

    @Override
    public void openAppearanceScreen() {
        VampirismMod.proxy.displayVampireMinionAppearanceScreen(this);
    }

    @Override
    public void openStatsScreen() {
        VampirismMod.proxy.displayVampireMinionStatsaScreen(this);
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> {
            d.useLordSkin = useLordSkin;
        });
    }

    public void setVampireType(int type, boolean minionSkin) {
        this.getMinionData().ifPresent(d -> {
            d.type = type;
            d.minionSkin = minionSkin;
        });
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> d.useLordSkin).orElse(false);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return false;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected boolean canConsume(@NotNull ItemStack stack) {
        boolean fullHealth;
        if (!super.canConsume(stack)) {
            return false;
        }
        if (stack.getFoodProperties((LivingEntity)this) != null && !(stack.getItem() instanceof VampirismItemBloodFoodItem)) {
            return false;
        }
        boolean bl = fullHealth = this.getHealth() == this.getMaxHealth();
        if (fullHealth && stack.getFoodProperties((LivingEntity)this) != null && stack.getItem() instanceof VampirismItemBloodFoodItem) {
            return false;
        }
        if (stack.getItem() instanceof BloodBottleItem && stack.getDamageValue() == 0) {
            return false;
        }
        return !fullHealth || !(stack.getItem() instanceof BloodBottleItem);
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.level().isClientSide() && this.isLord(player) && this.minionData != null && (heldItem = player.getItemInHand(hand)).getItem() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.getItem()).getFaction() == this.getFaction()) {
            if (((VampireMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.getItem()).getMinLevel() && ((VampireMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.getItem()).getMaxLevel()) {
                ++((VampireMinionData)this.minionData).level;
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.vampire_minion.binding_upgrade"), false);
                HelperLib.sync(this);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.vampire_minion.binding_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected void onMinionDataReceived(HolderLookup.Provider provider, @NotNull VampireMinionData data) {
        super.onMinionDataReceived(provider, data);
        this.updateAttributes();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(3, new RestrictSunVampireGoal<VampireMinionEntity>(this));
        this.goalSelector.addGoal(8, new FleeSunVampireGoal<VampireMinionEntity>(this, 1.0, true));
    }

    public void updateAttributes() {
        float statsMultiplier = this.getMinionData().filter(d -> d.hasIncreasedStats).map(a -> Float.valueOf(1.2f)).orElse(Float.valueOf(1.0f)).floatValue();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(VampireMinionData::getHealthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.ATTACK_DAMAGE);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.setBaseValue((3.0 + 1.0 * (double)this.getMinionData().map(VampireMinionData::getStrengthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((BalanceMobProps.mobProps.VAMPIRE_SPEED + 0.05 * (double)this.getMinionData().map(VampireMinionData::getSpeedLevel).orElse(0).intValue()) * (double)statsMultiplier);
    }

    public static class VampireMinionData
    extends MinionData {
        public static final ResourceLocation ID = VResourceLocation.mod("vampire");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_SPEED = 3;
        private int type;
        private boolean useLordSkin;
        private boolean minionSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int speedLevel;
        private boolean hasIncreasedStats;

        public VampireMinionData(String name, int type, boolean useLordSkin, boolean hasIncreasedStats) {
            super(name, 9);
            this.type = type;
            this.useLordSkin = useLordSkin;
            this.level = 0;
            this.minionSkin = false;
            this.hasIncreasedStats = hasIncreasedStats;
        }

        public VampireMinionData() {
        }

        @Override
        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            super.deserializeNBT(provider, nbt);
            this.type = nbt.getInt("vampire_type");
            this.level = nbt.getInt("level");
            this.useLordSkin = nbt.getBoolean("use_lord_skin");
            this.inventoryLevel = nbt.getInt("l_inv");
            this.healthLevel = nbt.getInt("l_he");
            this.strengthLevel = nbt.getInt("l_str");
            this.speedLevel = nbt.getInt("l_spe");
            this.minionSkin = nbt.getBoolean("ms");
            this.hasIncreasedStats = nbt.getBoolean("hasIncreasedStats");
        }

        @Override
        @NotNull
        public MutableComponent getFormattedName() {
            return super.getFormattedName().withStyle(style -> style.withColor(VReference.VAMPIRE_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        @Override
        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.speedLevel - this.strengthLevel);
        }

        public int getSpeedLevel() {
            return this.speedLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, @NotNull List<Integer> data) {
            this.setName(newName);
            block4: for (int i = 0; i < data.size(); ++i) {
                switch (i) {
                    case 0: {
                        this.type = data.get(i);
                        continue block4;
                    }
                    case 1: {
                        this.useLordSkin = (data.get(i) & 1) == 1;
                        this.minionSkin = (data.get(i) & 2) == 2;
                    }
                }
            }
        }

        @Override
        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.speedLevel > 0;
        }

        @Override
        public void resetStats(MinionEntity<?> entity) {
            assert (entity instanceof VampireMinionEntity);
            this.inventoryLevel = 0;
            this.healthLevel = 0;
            this.strengthLevel = 0;
            this.speedLevel = 0;
            this.getInventory().setAvailableSize(this.getInventorySize());
            ((VampireMinionEntity)entity).updateAttributes();
            super.resetStats(entity);
        }

        @Override
        public void serializeNBT(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
            super.serializeNBT(tag, provider);
            tag.putInt("vampire_type", this.type);
            tag.putInt("level", this.level);
            tag.putBoolean("use_lord_skin", this.useLordSkin);
            tag.putInt("l_inv", this.inventoryLevel);
            tag.putInt("l_he", this.healthLevel);
            tag.putInt("l_str", this.strengthLevel);
            tag.putInt("l_spe", this.speedLevel);
            tag.putBoolean("ms", this.minionSkin);
            tag.putBoolean("hasIncreasedStats", this.hasIncreasedStats);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, @NotNull MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof VampireMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.speedLevel >= 3) {
                        return false;
                    }
                    ++this.speedLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        public void setIncreasedStats(boolean hasIncreasedStats) {
            this.hasIncreasedStats = hasIncreasedStats;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setUseLordSkin(boolean useLordSkin) {
            this.useLordSkin = useLordSkin;
        }
    }
}

