/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.hunter;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.critereon.VampireActionCriterionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismAttachments;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.entity.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

public class HunterPlayer
extends FactionBasePlayer<IHunterPlayer>
implements IHunterPlayer {
    @NotNull
    private final ActionHandler<IHunterPlayer> actionHandler = new ActionHandler<HunterPlayer>(this);
    @NotNull
    private final SkillHandler<IHunterPlayer> skillHandler = new SkillHandler<IHunterPlayer>(this, VReference.HUNTER_FACTION);

    @NotNull
    public static HunterPlayer get(@NotNull Player player) {
        return (HunterPlayer)player.getData(ModAttachments.HUNTER_PLAYER);
    }

    @Deprecated
    @NotNull
    public static Optional<HunterPlayer> getOpt(@NotNull Player player) {
        return Optional.ofNullable((HunterPlayer)player.getData(ModAttachments.HUNTER_PLAYER));
    }

    public HunterPlayer(Player player) {
        super(player);
    }

    @Override
    public void breakDisguise() {
        this.actionHandler.deactivateAction((ILastingAction)HunterActions.DISGUISE_HUNTER.get());
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IActionHandler<IHunterPlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @NotNull
    public ResourceLocation getAttachedKey() {
        return VampirismAttachments.Keys.HUNTER_PLAYER;
    }

    @Override
    public IFaction<?> getDisguisedAs() {
        return this.player.hasEffect(ModEffects.DISGUISE_AS_VAMPIRE) ? VReference.VAMPIRE_FACTION : this.getFaction();
    }

    @Override
    public int getLevel() {
        return ((IVampirismPlayer)this.player).getVampAtts().hunterLevel;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @NotNull
    public ISkillHandler<IHunterPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @NotNull
    public HunterPlayerSpecialAttribute getSpecialAttributes() {
        return ((IVampirismPlayer)this.player).getVampAtts().getHuntSpecial();
    }

    @Override
    public boolean isDisguised() {
        return this.player.hasEffect(ModEffects.DISGUISE_AS_VAMPIRE);
    }

    @Override
    public void onChangedDimension(ResourceKey<Level> from, ResourceKey<Level> to) {
    }

    @Override
    public void onDeath(@NotNull DamageSource src) {
        super.onDeath(src);
        this.actionHandler.deactivateAllActions();
        if (src.getEntity() instanceof ServerPlayer && Helper.isVampire((Player)src.getEntity()) && this.getRepresentingPlayer().getEffect(ModEffects.FREEZE) != null) {
            ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger((ServerPlayer)src.getEntity(), VampireActionCriterionTrigger.Action.KILL_FROZEN_HUNTER);
        }
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        return false;
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    @Override
    public void onLevelChanged(int level, int oldLevel) {
        super.onLevelChanged(level, oldLevel);
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.HUNTER_LEVEL_CRITERIA, level);
            LevelAttributeModifier.applyModifier(this.player, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, "Hunter", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.hpStrengthMaxMod.get(), (Double)VampirismConfig.BALANCE.hpStrengthType.get(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE, false);
        }
    }

    @Override
    public void onPlayerLoggedIn() {
    }

    @Override
    public void onPlayerLoggedOut() {
    }

    @Override
    public void onUpdate() {
        this.player.getCommandSenderWorld().getProfiler().push("vampirism_hunterPlayer");
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    syncPacket.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeUpdateNBT((HolderLookup.Provider)this.asEntity().registryAccess()));
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncPacket.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeUpdateNBT((HolderLookup.Provider)this.asEntity().registryAccess()));
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            } else {
                if (this.getSpecialAttributes().blessingSoundReference != null && !this.player.isUsingItem()) {
                    this.getSpecialAttributes().blessingSoundReference.stopPlaying();
                    this.getSpecialAttributes().blessingSoundReference = null;
                }
                this.actionHandler.updateActions();
                VampirismMod.proxy.handleSleepClient(this.player);
            }
        } else if (this.player.level().getGameTime() % 100L == 16L && !OilUtils.getEquippedArmorOils(this.player).isEmpty()) {
            this.player.addEffect(new MobEffectInstance(ModEffects.POISON, 120, 0, false, false));
        }
        this.getSpecialAttributes().fullHunterCoat = level > 0 ? HunterCoatItem.isFullyEquipped(this.player) : null;
        this.player.getCommandSenderWorld().getProfiler().pop();
    }

    @Override
    public void onUpdatePlayer(PlayerTickEvent event) {
    }

    @Override
    public void deserializeUpdateNBT(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.deserializeUpdateNBT(provider, nbt);
        this.actionHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.actionHandler.nbtKey()));
        this.skillHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.skillHandler.nbtKey()));
    }

    @Override
    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.actionHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.actionHandler.nbtKey()));
        this.skillHandler.deserializeUpdateNBT(provider, nbt.getCompound(this.skillHandler.nbtKey()));
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeUpdateNBT(provider);
        tag.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeUpdateNBT(provider));
        tag.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeUpdateNBT(provider));
        return tag;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.put(this.actionHandler.nbtKey(), (Tag)this.actionHandler.serializeNBT(provider));
        tag.put(this.skillHandler.nbtKey(), (Tag)this.skillHandler.serializeNBT(provider));
        return tag;
    }

    @Override
    public void updateMinionAttributes(boolean increasedStats) {
        MinionWorldData.getData(this.player.level()).ifPresent(a -> a.getOrCreateController(FactionPlayerHandler.get(this.player)).contactMinions(minion -> {
            minion.getMinionData().ifPresent(b -> ((HunterMinionEntity.HunterMinionData)b).setIncreasedStats(increasedStats));
            HelperLib.sync(minion);
        }));
    }

    @Override
    public String nbtKey() {
        return this.getAttachedKey().getPath();
    }

    public static class Factory
    implements Function<IAttachmentHolder, HunterPlayer> {
        @Override
        public HunterPlayer apply(IAttachmentHolder holder) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                return new HunterPlayer(player);
            }
            throw new IllegalArgumentException("Cannot create hunter player attachment for holder " + String.valueOf(holder.getClass()) + ". Expected Player");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, HunterPlayer> {
        @NotNull
        public HunterPlayer read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                HunterPlayer hunter = new HunterPlayer(player);
                hunter.deserializeNBT(provider, tag);
                return hunter;
            }
            throw new IllegalArgumentException("Expected Player, got " + holder.getClass().getSimpleName());
        }

        public CompoundTag write(HunterPlayer attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

