/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.vampirism.advancements.critereon.VampireActionCriterionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;

public class BatVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntityDimensions BAT_SIZE = EntityDimensions.fixed((float)0.8f, (float)0.6f).withEyeHeight(0.51000005f);
    private static final float PLAYER_WIDTH = 0.6f;
    private static final float PLAYER_HEIGHT = 1.8f;

    @Override
    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        Player player = vampire.asEntity();
        this.setModifier(player, true);
        this.updatePlayer((VampirePlayer)vampire, true);
        if (player instanceof ServerPlayer) {
            ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger((ServerPlayer)player, VampireActionCriterionTrigger.Action.BAT);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(@NotNull IVampirePlayer vampire) {
        Player player = vampire.asEntity();
        return !vampire.isGettingSundamage((LevelAccessor)player.level()) && ModItems.UMBRELLA.asItem() != player.getMainHandItem().getItem() && vampire.isGettingGarlicDamage((LevelAccessor)player.level()) == EnumStrength.NONE && !vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get()) && !player.isInWater() && !((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(player.getCommandSenderWorld().dimension().location().toString()) && player.getVehicle() == null;
    }

    @Override
    public int getCooldown(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaBatCooldown.get() * 20 + 1;
    }

    @Override
    public int getDuration(IVampirePlayer player) {
        return Mth.clamp((int)((Integer)VampirismConfig.BALANCE.vaBatDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaBatEnabled.get();
    }

    @Override
    public void onActivatedClient(@NotNull IVampirePlayer vampire) {
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
            this.setModifier(vampire.asEntity(), true);
        }
    }

    @Override
    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        Player player = vampire.asEntity();
        this.setModifier(player, false);
        if (!player.onGround()) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 100, false, false));
        }
        this.updatePlayer((VampirePlayer)vampire, false);
        player.removeData(ModAttachments.VAMPIRE_BAT);
    }

    @Override
    public void onReActivated(@NotNull IVampirePlayer vampire) {
        this.setModifier(vampire.getRepresentingPlayer(), true);
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public boolean onUpdate(@NotNull IVampirePlayer vampire) {
        Player player = vampire.asEntity();
        if (vampire.isGettingSundamage((LevelAccessor)player.level()) && !vampire.isRemote()) {
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.cant_fly_day"));
            return true;
        }
        if (ModItems.UMBRELLA.get() == player.getMainHandItem().getItem() && !vampire.isRemote()) {
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.cant_fly_umbrella"));
            return true;
        }
        if (vampire.isGettingGarlicDamage((LevelAccessor)player.level()) != EnumStrength.NONE && !vampire.isRemote()) {
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.cant_fly_garlic"));
            return true;
        }
        if (((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(player.getCommandSenderWorld().dimension().location().toString())) {
            player.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.cant_fly_dimension"));
            return true;
        }
        float exhaustion = ((Double)VampirismConfig.BALANCE.vaBatExhaustion.get()).floatValue();
        if (exhaustion > 0.0f) {
            vampire.addExhaustion(exhaustion);
        }
        return player.isInWater();
    }

    private void setFlightSpeed(@NotNull Player player, float speed) {
        player.getAbilities().setFlyingSpeed(speed);
    }

    private void setModifier(@NotNull Player player, boolean enabled) {
        ResourceLocation key = ModRegistries.ACTIONS.getKey((Object)this);
        if (key == null) {
            return;
        }
        if (enabled) {
            AttributeInstance fly;
            AttributeInstance armorToughness;
            AttributeInstance armor = player.getAttribute(Attributes.ARMOR);
            if (armor != null && !armor.hasModifier(key)) {
                armor.addPermanentModifier(new AttributeModifier(key, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if ((armorToughness = player.getAttribute(Attributes.ARMOR_TOUGHNESS)) != null && !armorToughness.hasModifier(key)) {
                armorToughness.addPermanentModifier(new AttributeModifier(key, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if ((fly = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT)) != null && !fly.hasModifier(key)) {
                fly.addPermanentModifier(new AttributeModifier(key, 1.0, AttributeModifier.Operation.ADD_VALUE));
            }
            this.setFlightSpeed(player, ((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        } else {
            Objects.requireNonNull(player.getAttribute(Attributes.ARMOR)).removeModifier(key);
            Objects.requireNonNull(player.getAttribute(Attributes.ARMOR_TOUGHNESS)).removeModifier(key);
            Objects.requireNonNull(player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT)).removeModifier(key);
            this.setFlightSpeed(player, 0.05f);
        }
        player.onUpdateAbilities();
    }

    private void updatePlayer(@NotNull VampirePlayer vampire, boolean bat) {
        Player player = vampire.getRepresentingPlayer();
        vampire.getSpecialAttributes().bat = bat;
        player.setForcedPose((Pose)(bat ? Pose.STANDING : null));
        player.refreshDimensions();
        if (bat) {
            player.setPos(player.getX(), player.getY() + (double)(1.8f - BAT_SIZE.height()), player.getZ());
        }
    }

    @Override
    public boolean showHudDuration(Player player) {
        return true;
    }
}

