/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.core.ModMenus;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipeInput;
import de.teamlapen.vampirism.recipes.ITestableRecipeInput;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AlchemicalCauldronMenu
extends RecipeBookMenu<AlchemicalCauldronRecipeInput, AlchemicalCauldronRecipe> {
    public static final int INGREDIENT_SLOT = 1;
    public static final int FLUID_SLOT = 0;
    public static final int FUEL_SLOT = 3;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 4;
    public static final int DATA_COUNT = 4;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final Container container;
    protected final ContainerData data;
    protected final Level level;
    private final RecipeType<? extends AlchemicalCauldronRecipe> recipeType = (RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get();
    private final RecipeBookType recipeBookType = RecipeBookType.FURNACE;

    @Deprecated
    public AlchemicalCauldronMenu(int id, @NotNull Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(4));
    }

    public AlchemicalCauldronMenu(int id, @NotNull Inventory playerInventory, @NotNull Container inv, @NotNull ContainerData pData) {
        super((MenuType)ModMenus.ALCHEMICAL_CAULDRON.get(), id);
        AlchemicalCauldronMenu.checkContainerSize((Container)inv, (int)3);
        AlchemicalCauldronMenu.checkContainerDataCount((ContainerData)pData, (int)4);
        this.container = inv;
        this.data = pData;
        this.level = playerInventory.player.level();
        this.addSlot(new Slot(this.container, 0, 44, 17));
        this.addSlot(new Slot(this.container, 1, 68, 17));
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, this.container, 2, 116, 35));
        this.addSlot(new FurnaceFuelSlot(this, this.container, 3, 56, 53));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(pData);
    }

    public void fillCraftSlotsStackedContents(StackedContents pItemHelper) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(pItemHelper);
        }
    }

    public Optional<RecipeHolder<AlchemicalCauldronRecipe>> checkRecipeNoSkills() {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new AlchemicalCauldronRecipeInput(this.container.getItem(1), this.container.getItem(0), ITestableRecipeInput.TestType.BOTH), this.level);
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(1).set(ItemStack.EMPTY);
        this.getSlot(2).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<AlchemicalCauldronRecipe> pRecipe) {
        return ((AlchemicalCauldronRecipe)pRecipe.value()).matches(new AlchemicalCauldronRecipeInput(this.container.getItem(1), this.container.getItem(0)), this.level);
    }

    public int getResultSlotIndex() {
        return 2;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 4;
    }

    public boolean stillValid(Player pPlayer) {
        return this.container.stillValid(pPlayer);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 3) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (pIndex != 1 && pIndex != 2 && pIndex != 0) {
                boolean asIngredient;
                boolean asFluid = this.canSmeltAsFluid(itemstack1) && !this.moveItemStackTo(itemstack1, 0, 1, false);
                boolean bl = asIngredient = this.canSmeltAsIngredient(itemstack1) && !this.moveItemStackTo(itemstack1, 1, 2, false);
                if (asFluid || asIngredient) {
                    return ItemStack.EMPTY;
                }
                if (this.isFuel(itemstack1) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (pIndex >= 4 && pIndex < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : pIndex >= 31 && pIndex < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    protected boolean canSmeltAsIngredient(ItemStack pStack) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new AlchemicalCauldronRecipeInput(pStack, this.container.getItem(0), ITestableRecipeInput.TestType.INPUT_1), this.level).isPresent();
    }

    protected boolean canSmeltAsFluid(ItemStack pStack) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, (RecipeInput)new AlchemicalCauldronRecipeInput(this.container.getItem(1), pStack, ITestableRecipeInput.TestType.INPUT_2), this.level).isPresent();
    }

    protected boolean isFuel(ItemStack pStack) {
        return pStack.getBurnTime(this.recipeType) > 0;
    }

    public float getBurnProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    public boolean shouldMoveToInventory(int pSlotIndex) {
        return pSlotIndex != 2;
    }

    public static class FurnaceFuelSlot
    extends Slot {
        private final AlchemicalCauldronMenu menu;

        public FurnaceFuelSlot(AlchemicalCauldronMenu pFurnaceMenu, Container pFurnaceContainer, int pSlot, int pXPosition, int pYPosition) {
            super(pFurnaceContainer, pSlot, pXPosition, pYPosition);
            this.menu = pFurnaceMenu;
        }

        public boolean mayPlace(ItemStack pStack) {
            return this.menu.isFuel(pStack) || FurnaceFuelSlot.isBucket(pStack);
        }

        public int getMaxStackSize(ItemStack pStack) {
            return FurnaceFuelSlot.isBucket(pStack) ? 1 : super.getMaxStackSize(pStack);
        }

        public static boolean isBucket(ItemStack pStack) {
            return pStack.is(Items.BUCKET);
        }
    }
}

