/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.mixin;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity
implements IVampirismPlayer {
    @Unique
    private final VampirismPlayerAttributes vampirismPlayerAttributes = new VampirismPlayerAttributes();

    @Shadow
    public abstract Either<Player.BedSleepingProblem, Unit> startSleepInBed(BlockPos var1);

    private MixinPlayerEntity(@NotNull EntityType<? extends LivingEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    @Override
    @Unique
    public VampirismPlayerAttributes getVampAtts() {
        return this.vampirismPlayerAttributes;
    }

    @Inject(method={"canTakeItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void canTakeItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        IFactionExclusiveItem item;
        IFaction<?> exclusiveFaction;
        Item item2 = stack.getItem();
        if (item2 instanceof IFactionExclusiveItem && (exclusiveFaction = (item = (IFactionExclusiveItem)item2).getExclusiveFaction(stack)) != null && exclusiveFaction != this.vampirismPlayerAttributes.faction) {
            cir.setReturnValue((Object)false);
        }
    }
}

