/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.recipes;

import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.AlchemicalCauldronBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlchemicalCauldronRecipeRenderer
extends IRecipeRenderer.RecipeRendererBase<AlchemicalCauldronRecipe> {
    private final SubTexture CRAFTING_GRID = new SubTexture(ResourceLocation.fromNamespaceAndPath((String)"vampirismguide", (String)"textures/gui/alchemical_cauldron_recipe.png"), 0, 0, 110, 75);

    public AlchemicalCauldronRecipeRenderer(AlchemicalCauldronRecipe recipe) {
        super((Recipe)recipe);
    }

    public void draw(@NotNull GuiGraphics guiGraphics, RegistryAccess registryAccess, Book book, CategoryAbstract categoryAbstract, EntryAbstract entryAbstract, int guiLeft, int guiTop, int mouseX, int mouseY, @NotNull BaseScreen baseScreen, @NotNull Font font, @NotNull IngredientCycler ingredientCycler) {
        this.CRAFTING_GRID.draw(guiGraphics, guiLeft + 60, guiTop + 42);
        baseScreen.drawCenteredStringWithoutShadow(guiGraphics, font, (Component)((AlchemicalCauldronBlock)((Object)ModBlocks.ALCHEMICAL_CAULDRON.get())).getName(), guiLeft + baseScreen.xSize / 2, guiTop + 12, 0);
        MutableComponent mutableComponent = Component.literal((String)"\u00a7o").append((Component)Component.translatable((String)"guideapi.text.crafting.shaped")).append("\u00a7r");
        int n = guiLeft + baseScreen.xSize / 2;
        Objects.requireNonNull(font);
        baseScreen.drawCenteredStringWithoutShadow(guiGraphics, font, (Component)mutableComponent, n, guiTop + 14 + 9, 0);
        int outputX = guiLeft + 150;
        int outputY = guiTop + 72;
        int in1X = guiLeft + 78;
        int in1Y = guiTop + 59;
        int in2X = guiLeft + 108;
        int in2Y = guiTop + 59;
        ItemStack itemStack = ((AlchemicalCauldronRecipe)this.recipe).getResultItem((HolderLookup.Provider)registryAccess);
        GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)itemStack, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            this.tooltips = GuiHelper.getTooltip((ItemStack)itemStack);
        }
        Ingredient input = (Ingredient)((AlchemicalCauldronRecipe)this.recipe).getIngredients().get(0);
        ingredientCycler.getCycledIngredientStack(input, 0).ifPresent(inStack -> {
            GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)inStack, (int)in2X, (int)in2Y);
            if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)in2X, (int)in2Y, (int)15, (int)15)) {
                this.tooltips = GuiHelper.getTooltip((ItemStack)inStack);
            }
        });
        Ingredient liquid = (Ingredient)((AlchemicalCauldronRecipe)this.recipe).getFluid().map(ingredient -> ingredient, fluidStack -> Ingredient.of((ItemLike[])new ItemLike[]{fluidStack.getFluid().getBucket()}));
        ingredientCycler.getCycledIngredientStack(liquid, 1).ifPresent(fluidStack -> {
            GuiHelper.drawItemStack((GuiGraphics)guiGraphics, (ItemStack)fluidStack, (int)in1X, (int)in1Y);
            if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)in1X, (int)in1Y, (int)15, (int)15)) {
                this.tooltips = GuiHelper.getTooltip((ItemStack)fluidStack);
            }
        });
        int y = guiTop + 120;
        if (((AlchemicalCauldronRecipe)this.recipe).getRequiredLevel() > 1) {
            MutableComponent level = Component.translatable((String)"gui.vampirism.hunter_weapon_table.level", (Object[])new Object[]{((AlchemicalCauldronRecipe)this.recipe).getRequiredLevel()});
            guiGraphics.drawString(font, (Component)level, guiLeft + 50, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(font);
            y += 9 + 2;
        }
        if (!((AlchemicalCauldronRecipe)this.recipe).getRequiredSkills().isEmpty()) {
            MutableComponent newLine = Component.literal((String)"\n");
            ArrayList<MutableComponent> skills = new ArrayList<MutableComponent>();
            skills.add(Component.translatable((String)"gui.vampirism.skill_required", (Object[])new Object[]{"\n"}));
            for (ISkill<?> skill : ((AlchemicalCauldronRecipe)this.recipe).getRequiredSkills()) {
                skills.add(skill.getName().copy().withStyle(ChatFormatting.ITALIC));
                skills.add(newLine);
            }
            guiGraphics.drawWordWrap(font, FormattedText.composite(skills), guiLeft + 50, y, 100, Color.GRAY.getRGB());
        }
    }
}

