/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.terrablender;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.world.biome.OverworldModifications;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;
import terrablender.worldgen.RegionUtils;

public class TerraBlenderRegistration {
    public static void registerRegions() {
        Regions.register((Region)new ForestRegion());
    }

    public static void registerSurfaceRules() {
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"vampirism", (SurfaceRules.RuleSource)OverworldModifications.buildOverworldSurfaceRules());
    }

    static class ForestRegion
    extends Region {
        public ForestRegion() {
            super(VResourceLocation.mod("overworld"), RegionType.OVERWORLD, ((Integer)VampirismConfig.COMMON.vampireForestWeight_terrablender.get()).intValue());
        }

        public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
            this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
                ArrayList points = new ArrayList(RegionUtils.getVanillaParameterPoints((ResourceKey)Biomes.TAIGA));
                points.addAll(RegionUtils.getVanillaParameterPoints((ResourceKey)Biomes.FOREST));
                points.forEach(point -> builder.replaceBiome(point, ModBiomes.VAMPIRE_FOREST));
            });
        }
    }
}

