/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.util.FactionCodec;
import de.teamlapen.vampirism.util.StreamCodecExtension;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShapedWeaponTableRecipe
implements Recipe<CraftingInput>,
IWeaponTableRecipe {
    protected static final int MAX_WIDTH = 4;
    protected static final int MAX_HEIGHT = 4;
    private final CraftingBookCategory category;
    private final String group;
    private final ShapedRecipePattern pattern;
    private final ItemStack recipeOutput;
    private final int requiredLevel;
    @NotNull
    private final List<ISkill<IHunterPlayer>> requiredSkills;
    private final int requiredLava;

    public ShapedWeaponTableRecipe(String groupIn, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutputIn, int requiredLevel, @NotNull List<ISkill<IHunterPlayer>> requiredSkills, int requiredLava) {
        this.category = category;
        this.group = groupIn;
        this.pattern = pattern;
        this.recipeOutput = recipeOutputIn;
        this.requiredLevel = requiredLevel;
        this.requiredSkills = requiredSkills;
        this.requiredLava = requiredLava;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registryAccess) {
        return this.recipeOutput.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= this.pattern.width() && pHeight >= this.pattern.height();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registryAccess) {
        return this.recipeOutput;
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLava;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    @NotNull
    public List<ISkill<IHunterPlayer>> getRequiredSkills() {
        return this.requiredSkills;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SHAPED_CRAFTING_WEAPONTABLE.get();
    }

    @NotNull
    public RecipeType<IWeaponTableRecipe> getType() {
        return (RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get();
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level worldIn) {
        return this.pattern.matches(inv);
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedWeaponTableRecipe> {
        public static final MapCodec<ShapedWeaponTableRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.recipeOutput), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(p -> p.requiredLevel), (App)FactionCodec.skillCodec().listOf().optionalFieldOf("skill", Collections.emptyList()).forGetter(p -> p.requiredSkills), (App)Codec.INT.optionalFieldOf("lava", (Object)0).forGetter(p -> p.requiredLava)).apply((Applicative)inst, ShapedWeaponTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedWeaponTableRecipe> STREAM_CODEC = StreamCodecExtension.composite(ByteBufCodecs.STRING_UTF8, s -> s.group, CraftingBookCategory.STREAM_CODEC, s -> s.category, ShapedRecipePattern.STREAM_CODEC, s -> s.pattern, ItemStack.STREAM_CODEC, s -> s.recipeOutput, ByteBufCodecs.VAR_INT, s -> s.requiredLevel, FactionCodec.skillStreamCodec().apply(ByteBufCodecs.list()), s -> s.requiredSkills, ByteBufCodecs.VAR_INT, s -> s.requiredLava, ShapedWeaponTableRecipe::new);

        @NotNull
        public MapCodec<ShapedWeaponTableRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ShapedWeaponTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

