/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.util.FactionCodec;
import de.teamlapen.vampirism.util.StreamCodecExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;

public class ShapelessWeaponTableRecipe
implements Recipe<CraftingInput>,
IWeaponTableRecipe {
    protected static final int MAX_WIDTH = 4;
    protected static final int MAX_HEIGHT = 4;
    @NotNull
    private final CraftingBookCategory category;
    @NotNull
    private final String group;
    @NotNull
    private final NonNullList<Ingredient> recipeItems;
    @NotNull
    private final ItemStack recipeOutput;
    private final int requiredLevel;
    private final List<ISkill<IHunterPlayer>> requiredSkills;
    private final int requiredLava;
    private final boolean isSimple;

    public ShapelessWeaponTableRecipe(@NotNull String group, @NotNull CraftingBookCategory category, @NotNull NonNullList<Ingredient> ingredients, @NotNull ItemStack result, int level, int lava, @NotNull List<ISkill<IHunterPlayer>> skills) {
        this.category = category;
        this.group = group;
        this.recipeItems = ingredients;
        this.recipeOutput = result;
        this.requiredLevel = level;
        this.requiredLava = lava;
        this.requiredSkills = skills;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, @NotNull HolderLookup.Provider registryAccess) {
        return this.recipeOutput.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registryAccess) {
        return this.recipeOutput;
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLava;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    @NotNull
    public List<ISkill<IHunterPlayer>> getRequiredSkills() {
        return this.requiredSkills;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SHAPELESS_CRAFTING_WEAPONTABLE.get();
    }

    @NotNull
    public RecipeType<IWeaponTableRecipe> getType() {
        return (RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get();
    }

    public boolean matches(@NotNull CraftingInput inv, @NotNull Level worldIn) {
        StackedContents recipeitemhelper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.height(); ++j) {
            for (int k = 0; k < inv.width(); ++k) {
                ItemStack itemstack = inv.getItem(k + j * inv.width());
                if (itemstack.isEmpty()) continue;
                ++i;
                if (this.isSimple) {
                    recipeitemhelper.accountStack(new ItemStack((ItemLike)itemstack.getItem()));
                    continue;
                }
                inputs.add(itemstack);
            }
        }
        return i == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessWeaponTableRecipe> {
        public static final MapCodec<ShapelessWeaponTableRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 16 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(16)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.recipeItems), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.recipeOutput), (App)Codec.INT.optionalFieldOf("level", (Object)1).forGetter(p -> p.requiredLevel), (App)Codec.INT.optionalFieldOf("lava", (Object)0).forGetter(p -> p.requiredLava), (App)FactionCodec.skillCodec().listOf().optionalFieldOf("skill", Collections.emptyList()).forGetter(p -> p.requiredSkills)).apply((Applicative)inst, ShapelessWeaponTableRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessWeaponTableRecipe> STREAM_CODEC = StreamCodecExtension.composite(ByteBufCodecs.STRING_UTF8, s -> s.group, CraftingBookCategory.STREAM_CODEC, s -> s.category, Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()).map(s -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])s.toArray(Ingredient[]::new))), l -> l), s -> s.recipeItems, ItemStack.STREAM_CODEC, s -> s.recipeOutput, ByteBufCodecs.VAR_INT, s -> s.requiredLevel, ByteBufCodecs.VAR_INT, s -> s.requiredLava, FactionCodec.skillStreamCodec().apply(ByteBufCodecs.list()), s -> s.requiredSkills, ShapelessWeaponTableRecipe::new);

        @NotNull
        public MapCodec<ShapelessWeaponTableRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ShapelessWeaponTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

