/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.sit;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.sit.SitUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SitEntity
extends Entity {
    @Nullable
    private Vec3 playerPos;

    @NotNull
    public static SitEntity newEntity(@NotNull Level level, @NotNull BlockPos pos, double offset, Vec3 playerPos) {
        SitEntity e = (SitEntity)((EntityType)ModEntities.dummy_sit_entity.get()).create(level);
        e.setPos((double)pos.getX() + 0.5, (double)pos.getY() + offset, (double)pos.getZ() + 0.5);
        e.noPhysics = true;
        e.setPlayerPos(playerPos);
        return e;
    }

    public SitEntity(@NotNull EntityType<SitEntity> type, @NotNull Level level) {
        super(type, level);
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            Vec3 resetPosition = this.getPlayerPos();
            if (resetPosition != null) {
                BlockPos belowResetPos = BlockPos.containing((double)resetPosition.x, (double)(resetPosition.y - 1.0), (double)resetPosition.z);
                this.discard();
                if (!player.level().getBlockState(belowResetPos).isFaceSturdy((BlockGetter)this.level(), belowResetPos, Direction.UP, SupportType.FULL)) {
                    return new Vec3(resetPosition.x, resetPosition.y + 1.0, resetPosition.z);
                }
                return resetPosition;
            }
        }
        this.discard();
        return super.getDismountLocationForPassenger(passenger);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        SitUtil.addSitEntity(this.level(), this.blockPosition(), this);
    }

    public void remove(Entity.RemovalReason reason) {
        this.ejectPassengers();
        SitUtil.removeSitEntity(this.level(), this.blockPosition());
        super.remove(reason);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("playerPosX")) {
            this.playerPos = new Vec3(tag.getDouble("playerPosX"), tag.getDouble("playerPosY"), tag.getDouble("playerPosZ"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.playerPos != null) {
            tag.putDouble("playerPosX", this.playerPos.x);
            tag.putDouble("playerPosY", this.playerPos.y);
            tag.putDouble("playerPosZ", this.playerPos.z);
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_146866_) {
        super.recreateFromPacket(p_146866_);
    }

    public void setPlayerPos(@Nullable Vec3 pos) {
        this.playerPos = pos;
    }

    @Nullable
    public Vec3 getPlayerPos() {
        return this.playerPos;
    }
}

